<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyaltyType Structs
 * @subpackage Structs
 */
class LoyaltyType extends AbstractStructBase
{
    /**
     * The ProgramName
     * @var string
     */
    public $ProgramName;
    /**
     * The MembershipID
     * @var string
     */
    public $MembershipID;
    /**
     * The LoyaltyLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\CodeDescriptionType
     */
    public $LoyaltyLevel;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $ExpireDate;
    /**
     * The Remark
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Remark;
    /**
     * Constructor method for LoyaltyType
     * @uses LoyaltyType::setProgramName()
     * @uses LoyaltyType::setMembershipID()
     * @uses LoyaltyType::setLoyaltyLevel()
     * @uses LoyaltyType::setEffectiveDate()
     * @uses LoyaltyType::setExpireDate()
     * @uses LoyaltyType::setRemark()
     * @param string $programName
     * @param string $membershipID
     * @param \Sabre\CreatePassengerNameRecord\Structs\CodeDescriptionType $loyaltyLevel
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string[] $remark
     */
    public function __construct($programName = null, $membershipID = null, \Sabre\CreatePassengerNameRecord\Structs\CodeDescriptionType $loyaltyLevel = null, $effectiveDate = null, $expireDate = null, array $remark = array())
    {
        $this
            ->setProgramName($programName)
            ->setMembershipID($membershipID)
            ->setLoyaltyLevel($loyaltyLevel)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setRemark($remark);
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \Sabre\CreatePassengerNameRecord\Structs\LoyaltyType
     */
    public function setProgramName($programName = null)
    {
        $this->ProgramName = $programName;
        return $this;
    }
    /**
     * Get MembershipID value
     * @return string|null
     */
    public function getMembershipID()
    {
        return $this->MembershipID;
    }
    /**
     * Set MembershipID value
     * @param string $membershipID
     * @return \Sabre\CreatePassengerNameRecord\Structs\LoyaltyType
     */
    public function setMembershipID($membershipID = null)
    {
        $this->MembershipID = $membershipID;
        return $this;
    }
    /**
     * Get LoyaltyLevel value
     * @return \Sabre\CreatePassengerNameRecord\Structs\CodeDescriptionType|null
     */
    public function getLoyaltyLevel()
    {
        return $this->LoyaltyLevel;
    }
    /**
     * Set LoyaltyLevel value
     * @param \Sabre\CreatePassengerNameRecord\Structs\CodeDescriptionType $loyaltyLevel
     * @return \Sabre\CreatePassengerNameRecord\Structs\LoyaltyType
     */
    public function setLoyaltyLevel(\Sabre\CreatePassengerNameRecord\Structs\CodeDescriptionType $loyaltyLevel = null)
    {
        $this->LoyaltyLevel = $loyaltyLevel;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \Sabre\CreatePassengerNameRecord\Structs\LoyaltyType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \Sabre\CreatePassengerNameRecord\Structs\LoyaltyType
     */
    public function setExpireDate($expireDate = null)
    {
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get Remark value
     * @return string[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param string[] $remark
     * @return \Sabre\CreatePassengerNameRecord\Structs\LoyaltyType
     */
    public function setRemark(array $remark = array())
    {
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\LoyaltyType
     */
    public function addToRemark($item)
    {
        $this->Remark[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\LoyaltyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
