<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelTotalPricing Structs
 * @subpackage Structs
 */
class HotelTotalPricing extends AbstractStructBase
{
    /**
     * The TotalTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\TotalTax
     */
    public $TotalTax;
    /**
     * The TotalSurcharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\TotalSurcharge
     */
    public $TotalSurcharge;
    /**
     * The ApproximateTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\ApproximateTotal
     */
    public $ApproximateTotal;
    /**
     * The RateChange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 8
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\RateChange[]
     */
    public $RateChange;
    /**
     * The Disclaimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Disclaimer[]
     */
    public $Disclaimer;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: The code specifying a monetary unit. Use ISO 4217, three alpha code
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for HotelTotalPricing
     * @uses HotelTotalPricing::setTotalTax()
     * @uses HotelTotalPricing::setTotalSurcharge()
     * @uses HotelTotalPricing::setApproximateTotal()
     * @uses HotelTotalPricing::setRateChange()
     * @uses HotelTotalPricing::setDisclaimer()
     * @uses HotelTotalPricing::setCurrencyCode()
     * @param \Sabre\CreatePassengerNameRecord\Structs\TotalTax $totalTax
     * @param \Sabre\CreatePassengerNameRecord\Structs\TotalSurcharge $totalSurcharge
     * @param \Sabre\CreatePassengerNameRecord\Structs\ApproximateTotal $approximateTotal
     * @param \Sabre\CreatePassengerNameRecord\Structs\RateChange[] $rateChange
     * @param \Sabre\CreatePassengerNameRecord\Structs\Disclaimer[] $disclaimer
     * @param string $currencyCode
     */
    public function __construct(\Sabre\CreatePassengerNameRecord\Structs\TotalTax $totalTax = null, \Sabre\CreatePassengerNameRecord\Structs\TotalSurcharge $totalSurcharge = null, \Sabre\CreatePassengerNameRecord\Structs\ApproximateTotal $approximateTotal = null, array $rateChange = array(), array $disclaimer = array(), $currencyCode = null)
    {
        $this
            ->setTotalTax($totalTax)
            ->setTotalSurcharge($totalSurcharge)
            ->setApproximateTotal($approximateTotal)
            ->setRateChange($rateChange)
            ->setDisclaimer($disclaimer)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get TotalTax value
     * @return \Sabre\CreatePassengerNameRecord\Structs\TotalTax|null
     */
    public function getTotalTax()
    {
        return $this->TotalTax;
    }
    /**
     * Set TotalTax value
     * @param \Sabre\CreatePassengerNameRecord\Structs\TotalTax $totalTax
     * @return \Sabre\CreatePassengerNameRecord\Structs\HotelTotalPricing
     */
    public function setTotalTax(\Sabre\CreatePassengerNameRecord\Structs\TotalTax $totalTax = null)
    {
        $this->TotalTax = $totalTax;
        return $this;
    }
    /**
     * Get TotalSurcharge value
     * @return \Sabre\CreatePassengerNameRecord\Structs\TotalSurcharge|null
     */
    public function getTotalSurcharge()
    {
        return $this->TotalSurcharge;
    }
    /**
     * Set TotalSurcharge value
     * @param \Sabre\CreatePassengerNameRecord\Structs\TotalSurcharge $totalSurcharge
     * @return \Sabre\CreatePassengerNameRecord\Structs\HotelTotalPricing
     */
    public function setTotalSurcharge(\Sabre\CreatePassengerNameRecord\Structs\TotalSurcharge $totalSurcharge = null)
    {
        $this->TotalSurcharge = $totalSurcharge;
        return $this;
    }
    /**
     * Get ApproximateTotal value
     * @return \Sabre\CreatePassengerNameRecord\Structs\ApproximateTotal|null
     */
    public function getApproximateTotal()
    {
        return $this->ApproximateTotal;
    }
    /**
     * Set ApproximateTotal value
     * @param \Sabre\CreatePassengerNameRecord\Structs\ApproximateTotal $approximateTotal
     * @return \Sabre\CreatePassengerNameRecord\Structs\HotelTotalPricing
     */
    public function setApproximateTotal(\Sabre\CreatePassengerNameRecord\Structs\ApproximateTotal $approximateTotal = null)
    {
        $this->ApproximateTotal = $approximateTotal;
        return $this;
    }
    /**
     * Get RateChange value
     * @return \Sabre\CreatePassengerNameRecord\Structs\RateChange[]|null
     */
    public function getRateChange()
    {
        return $this->RateChange;
    }
    /**
     * Set RateChange value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\RateChange[] $rateChange
     * @return \Sabre\CreatePassengerNameRecord\Structs\HotelTotalPricing
     */
    public function setRateChange(array $rateChange = array())
    {
        $this->RateChange = $rateChange;
        return $this;
    }
    /**
     * Add item to RateChange value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\RateChange $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\HotelTotalPricing
     */
    public function addToRateChange(\Sabre\CreatePassengerNameRecord\Structs\RateChange $item)
    {
        $this->RateChange[] = $item;
        return $this;
    }
    /**
     * Get Disclaimer value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Disclaimer[]|null
     */
    public function getDisclaimer()
    {
        return $this->Disclaimer;
    }
    /**
     * Set Disclaimer value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Disclaimer[] $disclaimer
     * @return \Sabre\CreatePassengerNameRecord\Structs\HotelTotalPricing
     */
    public function setDisclaimer(array $disclaimer = array())
    {
        $this->Disclaimer = $disclaimer;
        return $this;
    }
    /**
     * Add item to Disclaimer value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Disclaimer $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\HotelTotalPricing
     */
    public function addToDisclaimer(\Sabre\CreatePassengerNameRecord\Structs\Disclaimer $item)
    {
        $this->Disclaimer[] = $item;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\HotelTotalPricing
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\HotelTotalPricing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
