<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageAllowance Structs
 * @subpackage Structs
 */
class BaggageAllowance extends AbstractStructBase
{
    /**
     * The Segment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Segment
     */
    public $Segment;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - documentation: "Number" is used to return the baggage allowance type associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Weight;
    /**
     * Constructor method for BaggageAllowance
     * @uses BaggageAllowance::setSegment()
     * @uses BaggageAllowance::setNumber()
     * @uses BaggageAllowance::setWeight()
     * @param \Sabre\CreatePassengerNameRecord\Structs\Segment $segment
     * @param string $number
     * @param string $weight
     */
    public function __construct(\Sabre\CreatePassengerNameRecord\Structs\Segment $segment = null, $number = null, $weight = null)
    {
        $this
            ->setSegment($segment)
            ->setNumber($number)
            ->setWeight($weight);
    }
    /**
     * Get Segment value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Segment|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Segment $segment
     * @return \Sabre\CreatePassengerNameRecord\Structs\BaggageAllowance
     */
    public function setSegment(\Sabre\CreatePassengerNameRecord\Structs\Segment $segment = null)
    {
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Sabre\CreatePassengerNameRecord\Structs\BaggageAllowance
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param string $weight
     * @return \Sabre\CreatePassengerNameRecord\Structs\BaggageAllowance
     */
    public function setWeight($weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\BaggageAllowance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
