<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address Structs
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The AddressLine
     * Meta informations extracted from the WSDL
     * - documentation: "AddressLine" is used to return the address associated with the particular credit card holder. | "AddressLine" is used to return hotel address-related information. | "AddressLine" is used to return the collection site address
     * associated with the vehicle reservation if applicable. | "AddressLine" is used to return the delivery site address associated with the vehicle reservation if applicable.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AddressLine;
    /**
     * The CityName
     * Meta informations extracted from the WSDL
     * - documentation: "CityName" is used to return the collection site city name associated with the vehicle reservation if applicable. | "CityName" is used to return the delivery site city name associated with the vehicle reservation if applicable.
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - documentation: "CountryCode" is used to return hotel's particular country code. | "CountryCode" is used to return the collection site country code associated with the vehicle reservation if applicable. | "CountryCode" is used to return the delivery
     * site country code associated with the vehicle reservation if applicable.
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - documentation: "PostalCode" is used to return the collection site postal code associated with the vehicle reservation if applicable. | "PostalCode" is used to return the delivery site postal code associated with the vehicle reservation if
     * applicable.
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The StateCountyProv
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\StateCountyProv
     */
    public $StateCountyProv;
    /**
     * The StreetNmbr
     * Meta informations extracted from the WSDL
     * - documentation: "StreetNmbr" is used to return the collection site street address associated with the vehicle reservation if applicable. | "StreetNmbr" is used to return the delivery site street address associated with the vehicle reservation if
     * applicable.
     * - minOccurs: 0
     * @var string
     */
    public $StreetNmbr;
    /**
     * The VendorPrefs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\VendorPrefs
     */
    public $VendorPrefs;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for Address
     * @uses Address::setAddressLine()
     * @uses Address::setCityName()
     * @uses Address::setCountryCode()
     * @uses Address::setPostalCode()
     * @uses Address::setStateCountyProv()
     * @uses Address::setStreetNmbr()
     * @uses Address::setVendorPrefs()
     * @uses Address::setCity()
     * @uses Address::setState()
     * @uses Address::setZipCode()
     * @param string[] $addressLine
     * @param string $cityName
     * @param string $countryCode
     * @param string $postalCode
     * @param \Sabre\CreatePassengerNameRecord\Structs\StateCountyProv $stateCountyProv
     * @param string $streetNmbr
     * @param \Sabre\CreatePassengerNameRecord\Structs\VendorPrefs $vendorPrefs
     * @param string $city
     * @param string $state
     * @param string $zipCode
     */
    public function __construct(array $addressLine = array(), $cityName = null, $countryCode = null, $postalCode = null, \Sabre\CreatePassengerNameRecord\Structs\StateCountyProv $stateCountyProv = null, $streetNmbr = null, \Sabre\CreatePassengerNameRecord\Structs\VendorPrefs $vendorPrefs = null, $city = null, $state = null, $zipCode = null)
    {
        $this
            ->setAddressLine($addressLine)
            ->setCityName($cityName)
            ->setCountryCode($countryCode)
            ->setPostalCode($postalCode)
            ->setStateCountyProv($stateCountyProv)
            ->setStreetNmbr($streetNmbr)
            ->setVendorPrefs($vendorPrefs)
            ->setCity($city)
            ->setState($state)
            ->setZipCode($zipCode);
    }
    /**
     * Get AddressLine value
     * @return string[]|null
     */
    public function getAddressLine()
    {
        return $this->AddressLine;
    }
    /**
     * Set AddressLine value
     * @throws \InvalidArgumentException
     * @param string[] $addressLine
     * @return \Sabre\CreatePassengerNameRecord\Structs\Address
     */
    public function setAddressLine(array $addressLine = array())
    {
        $this->AddressLine = $addressLine;
        return $this;
    }
    /**
     * Add item to AddressLine value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\Address
     */
    public function addToAddressLine($item)
    {
        $this->AddressLine[] = $item;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \Sabre\CreatePassengerNameRecord\Structs\Address
     */
    public function setCityName($cityName = null)
    {
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Address
     */
    public function setCountryCode($countryCode = null)
    {
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Address
     */
    public function setPostalCode($postalCode = null)
    {
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get StateCountyProv value
     * @return \Sabre\CreatePassengerNameRecord\Structs\StateCountyProv|null
     */
    public function getStateCountyProv()
    {
        return $this->StateCountyProv;
    }
    /**
     * Set StateCountyProv value
     * @param \Sabre\CreatePassengerNameRecord\Structs\StateCountyProv $stateCountyProv
     * @return \Sabre\CreatePassengerNameRecord\Structs\Address
     */
    public function setStateCountyProv(\Sabre\CreatePassengerNameRecord\Structs\StateCountyProv $stateCountyProv = null)
    {
        $this->StateCountyProv = $stateCountyProv;
        return $this;
    }
    /**
     * Get StreetNmbr value
     * @return string|null
     */
    public function getStreetNmbr()
    {
        return $this->StreetNmbr;
    }
    /**
     * Set StreetNmbr value
     * @param string $streetNmbr
     * @return \Sabre\CreatePassengerNameRecord\Structs\Address
     */
    public function setStreetNmbr($streetNmbr = null)
    {
        $this->StreetNmbr = $streetNmbr;
        return $this;
    }
    /**
     * Get VendorPrefs value
     * @return \Sabre\CreatePassengerNameRecord\Structs\VendorPrefs|null
     */
    public function getVendorPrefs()
    {
        return $this->VendorPrefs;
    }
    /**
     * Set VendorPrefs value
     * @param \Sabre\CreatePassengerNameRecord\Structs\VendorPrefs $vendorPrefs
     * @return \Sabre\CreatePassengerNameRecord\Structs\Address
     */
    public function setVendorPrefs(\Sabre\CreatePassengerNameRecord\Structs\VendorPrefs $vendorPrefs = null)
    {
        $this->VendorPrefs = $vendorPrefs;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Sabre\CreatePassengerNameRecord\Structs\Address
     */
    public function setCity($city = null)
    {
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \Sabre\CreatePassengerNameRecord\Structs\Address
     */
    public function setState($state = null)
    {
        $this->State = $state;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Address
     */
    public function setZipCode($zipCode = null)
    {
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
