<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Voucher Structs
 * @subpackage Structs
 */
class Voucher extends AbstractStructBase
{
    /**
     * The BillingNumber
     * Meta informations extracted from the WSDL
     * - documentation: "BillingNumber" used to return the voucher billing number associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $BillingNumber;
    /**
     * The Format
     * Meta informations extracted from the WSDL
     * - documentation: "Format" is used to return the voucher format associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $Format;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: "ID" is used to return the voucher ID associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $ID;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: "Type" is used to return the type of voucher associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Voucher
     * @uses Voucher::setBillingNumber()
     * @uses Voucher::setFormat()
     * @uses Voucher::setID()
     * @uses Voucher::setType()
     * @param string $billingNumber
     * @param string $format
     * @param string $iD
     * @param string $type
     */
    public function __construct($billingNumber = null, $format = null, $iD = null, $type = null)
    {
        $this
            ->setBillingNumber($billingNumber)
            ->setFormat($format)
            ->setID($iD)
            ->setType($type);
    }
    /**
     * Get BillingNumber value
     * @return string|null
     */
    public function getBillingNumber()
    {
        return $this->BillingNumber;
    }
    /**
     * Set BillingNumber value
     * @param string $billingNumber
     * @return \Sabre\CreatePassengerNameRecord\Structs\Voucher
     */
    public function setBillingNumber($billingNumber = null)
    {
        $this->BillingNumber = $billingNumber;
        return $this;
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \Sabre\CreatePassengerNameRecord\Structs\Voucher
     */
    public function setFormat($format = null)
    {
        $this->Format = $format;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \Sabre\CreatePassengerNameRecord\Structs\Voucher
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\CreatePassengerNameRecord\Structs\Voucher
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\Voucher
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
