<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vendor Structs
 * @subpackage Structs
 */
class Vendor extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: "Code" is used to return the vendor code associated with the particular segment. | "Code" is used to return the vendor code associated with the particular cruise segment. | "Code" is used to return the vendor code associated with the
     * particular insurance segment. | "Code" is used to return the vendor code associated with the particular segment. | "Code" is used to return the vendor code associated with the particular rail segment. | "Code" is used to return the vendor code
     * associated with the particular segment. | "Code" is used to return the vehicle vendor code.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The CompanyShortName
     * Meta informations extracted from the WSDL
     * - documentation: "CompanyShortName" is used to return the vendor's name associated with the particular insurance segment. | "CompanyShortName" is used to return the company name associated with the particular vehicle vendor code.
     * - use: optional
     * @var string
     */
    public $CompanyShortName;
    /**
     * Constructor method for Vendor
     * @uses Vendor::setCode()
     * @uses Vendor::setCompanyShortName()
     * @param string $code
     * @param string $companyShortName
     */
    public function __construct($code = null, $companyShortName = null)
    {
        $this
            ->setCode($code)
            ->setCompanyShortName($companyShortName);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\CreatePassengerNameRecord\Structs\Vendor
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CompanyShortName value
     * @return string|null
     */
    public function getCompanyShortName()
    {
        return $this->CompanyShortName;
    }
    /**
     * Set CompanyShortName value
     * @param string $companyShortName
     * @return \Sabre\CreatePassengerNameRecord\Structs\Vendor
     */
    public function setCompanyShortName($companyShortName = null)
    {
        $this->CompanyShortName = $companyShortName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\Vendor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
