<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Taxes Structs
 * Meta informations extracted from the WSDL
 * - documentation: Taxes is used as a container for Tax details. It holds the details for GST, QST and Tax. For GST information about amount, Currency code and Percentage is present for QST and Tax along with information about amount, Currency code,
 * Percentage Tax code details is also included. | "Taxes" is used to reflect the total tax details | "Taxes" is used to reflect the total tax details | Taxes is used to reflect the total tax details | "Taxes" element is used as container for taxes
 * associated with particular ancillary.
 * @subpackage Structs
 */
class Taxes extends AbstractStructBase
{
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Tax[]
     */
    public $Tax;
    /**
     * The NoTax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\NoTax
     */
    public $NoTax;
    /**
     * The TaxExempt
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\TaxExempt[]
     */
    public $TaxExempt;
    /**
     * The TaxOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\TaxOverride[]
     */
    public $TaxOverride;
    /**
     * The Ind
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Ind;
    /**
     * The TotalAmount
     * Meta informations extracted from the WSDL
     * - documentation: "TotalAmount" is used to return the applicable amount. | "TotalAmount" is used to return the applicable amount.
     * - use: optional
     * @var string
     */
    public $TotalAmount;
    /**
     * The GST
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\GST
     */
    public $GST;
    /**
     * The QST
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\QST
     */
    public $QST;
    /**
     * The TaxBreakdownCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\TaxBreakdownCode[]
     */
    public $TaxBreakdownCode;
    /**
     * Constructor method for Taxes
     * @uses Taxes::setTax()
     * @uses Taxes::setNoTax()
     * @uses Taxes::setTaxExempt()
     * @uses Taxes::setTaxOverride()
     * @uses Taxes::setInd()
     * @uses Taxes::setTotalAmount()
     * @uses Taxes::setGST()
     * @uses Taxes::setQST()
     * @uses Taxes::setTaxBreakdownCode()
     * @param \Sabre\CreatePassengerNameRecord\Structs\Tax[] $tax
     * @param \Sabre\CreatePassengerNameRecord\Structs\NoTax $noTax
     * @param \Sabre\CreatePassengerNameRecord\Structs\TaxExempt[] $taxExempt
     * @param \Sabre\CreatePassengerNameRecord\Structs\TaxOverride[] $taxOverride
     * @param string $ind
     * @param string $totalAmount
     * @param \Sabre\CreatePassengerNameRecord\Structs\GST $gST
     * @param \Sabre\CreatePassengerNameRecord\Structs\QST $qST
     * @param \Sabre\CreatePassengerNameRecord\Structs\TaxBreakdownCode[] $taxBreakdownCode
     */
    public function __construct(array $tax = array(), \Sabre\CreatePassengerNameRecord\Structs\NoTax $noTax = null, array $taxExempt = array(), array $taxOverride = array(), $ind = null, $totalAmount = null, \Sabre\CreatePassengerNameRecord\Structs\GST $gST = null, \Sabre\CreatePassengerNameRecord\Structs\QST $qST = null, array $taxBreakdownCode = array())
    {
        $this
            ->setTax($tax)
            ->setNoTax($noTax)
            ->setTaxExempt($taxExempt)
            ->setTaxOverride($taxOverride)
            ->setInd($ind)
            ->setTotalAmount($totalAmount)
            ->setGST($gST)
            ->setQST($qST)
            ->setTaxBreakdownCode($taxBreakdownCode);
    }
    /**
     * Get Tax value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tax[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Tax[] $tax
     * @return \Sabre\CreatePassengerNameRecord\Structs\Taxes
     */
    public function setTax(array $tax = array())
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Tax $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\Taxes
     */
    public function addToTax(\Sabre\CreatePassengerNameRecord\Structs\Tax $item)
    {
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get NoTax value
     * @return \Sabre\CreatePassengerNameRecord\Structs\NoTax|null
     */
    public function getNoTax()
    {
        return $this->NoTax;
    }
    /**
     * Set NoTax value
     * @param \Sabre\CreatePassengerNameRecord\Structs\NoTax $noTax
     * @return \Sabre\CreatePassengerNameRecord\Structs\Taxes
     */
    public function setNoTax(\Sabre\CreatePassengerNameRecord\Structs\NoTax $noTax = null)
    {
        $this->NoTax = $noTax;
        return $this;
    }
    /**
     * Get TaxExempt value
     * @return \Sabre\CreatePassengerNameRecord\Structs\TaxExempt[]|null
     */
    public function getTaxExempt()
    {
        return $this->TaxExempt;
    }
    /**
     * Set TaxExempt value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\TaxExempt[] $taxExempt
     * @return \Sabre\CreatePassengerNameRecord\Structs\Taxes
     */
    public function setTaxExempt(array $taxExempt = array())
    {
        $this->TaxExempt = $taxExempt;
        return $this;
    }
    /**
     * Add item to TaxExempt value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\TaxExempt $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\Taxes
     */
    public function addToTaxExempt(\Sabre\CreatePassengerNameRecord\Structs\TaxExempt $item)
    {
        $this->TaxExempt[] = $item;
        return $this;
    }
    /**
     * Get TaxOverride value
     * @return \Sabre\CreatePassengerNameRecord\Structs\TaxOverride[]|null
     */
    public function getTaxOverride()
    {
        return $this->TaxOverride;
    }
    /**
     * Set TaxOverride value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\TaxOverride[] $taxOverride
     * @return \Sabre\CreatePassengerNameRecord\Structs\Taxes
     */
    public function setTaxOverride(array $taxOverride = array())
    {
        $this->TaxOverride = $taxOverride;
        return $this;
    }
    /**
     * Add item to TaxOverride value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\TaxOverride $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\Taxes
     */
    public function addToTaxOverride(\Sabre\CreatePassengerNameRecord\Structs\TaxOverride $item)
    {
        $this->TaxOverride[] = $item;
        return $this;
    }
    /**
     * Get Ind value
     * @return string|null
     */
    public function getInd()
    {
        return $this->Ind;
    }
    /**
     * Set Ind value
     * @param string $ind
     * @return \Sabre\CreatePassengerNameRecord\Structs\Taxes
     */
    public function setInd($ind = null)
    {
        $this->Ind = $ind;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return string|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param string $totalAmount
     * @return \Sabre\CreatePassengerNameRecord\Structs\Taxes
     */
    public function setTotalAmount($totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get GST value
     * @return \Sabre\CreatePassengerNameRecord\Structs\GST|null
     */
    public function getGST()
    {
        return $this->GST;
    }
    /**
     * Set GST value
     * @param \Sabre\CreatePassengerNameRecord\Structs\GST $gST
     * @return \Sabre\CreatePassengerNameRecord\Structs\Taxes
     */
    public function setGST(\Sabre\CreatePassengerNameRecord\Structs\GST $gST = null)
    {
        $this->GST = $gST;
        return $this;
    }
    /**
     * Get QST value
     * @return \Sabre\CreatePassengerNameRecord\Structs\QST|null
     */
    public function getQST()
    {
        return $this->QST;
    }
    /**
     * Set QST value
     * @param \Sabre\CreatePassengerNameRecord\Structs\QST $qST
     * @return \Sabre\CreatePassengerNameRecord\Structs\Taxes
     */
    public function setQST(\Sabre\CreatePassengerNameRecord\Structs\QST $qST = null)
    {
        $this->QST = $qST;
        return $this;
    }
    /**
     * Get TaxBreakdownCode value
     * @return \Sabre\CreatePassengerNameRecord\Structs\TaxBreakdownCode[]|null
     */
    public function getTaxBreakdownCode()
    {
        return $this->TaxBreakdownCode;
    }
    /**
     * Set TaxBreakdownCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\TaxBreakdownCode[] $taxBreakdownCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Taxes
     */
    public function setTaxBreakdownCode(array $taxBreakdownCode = array())
    {
        $this->TaxBreakdownCode = $taxBreakdownCode;
        return $this;
    }
    /**
     * Add item to TaxBreakdownCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\TaxBreakdownCode $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\Taxes
     */
    public function addToTaxBreakdownCode(\Sabre\CreatePassengerNameRecord\Structs\TaxBreakdownCode $item)
    {
        $this->TaxBreakdownCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\Taxes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
