<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxInfo Structs
 * @subpackage Structs
 */
class TaxInfo extends AbstractStructBase
{
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Taxes
     */
    public $Taxes;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $RPH;
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var float
     */
    public $Total;
    /**
     * Constructor method for TaxInfo
     * @uses TaxInfo::setTaxes()
     * @uses TaxInfo::setRPH()
     * @uses TaxInfo::setTotal()
     * @param \Sabre\CreatePassengerNameRecord\Structs\Taxes $taxes
     * @param int $rPH
     * @param float $total
     */
    public function __construct(\Sabre\CreatePassengerNameRecord\Structs\Taxes $taxes = null, $rPH = null, $total = null)
    {
        $this
            ->setTaxes($taxes)
            ->setRPH($rPH)
            ->setTotal($total);
    }
    /**
     * Get Taxes value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Taxes $taxes
     * @return \Sabre\CreatePassengerNameRecord\Structs\TaxInfo
     */
    public function setTaxes(\Sabre\CreatePassengerNameRecord\Structs\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get RPH value
     * @return int|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param int $rPH
     * @return \Sabre\CreatePassengerNameRecord\Structs\TaxInfo
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param float $total
     * @return \Sabre\CreatePassengerNameRecord\Structs\TaxInfo
     */
    public function setTotal($total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\TaxInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
