<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax Structs
 * Meta informations extracted from the WSDL
 * - documentation: "Tax" returns the individual Tax details | "Tax' returns the individual Tax details
 * @subpackage Structs
 */
class Tax extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return the applicable amount. | "Amount" is used to return the applicable amount. | "Amount" is used to return the applicable tax amount
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The TaxCode
     * Meta informations extracted from the WSDL
     * - documentation: "TaxCode" is used to return the applicable tax code.
     * - use: optional
     * @var string
     */
    public $TaxCode;
    /**
     * The TaxName
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TaxName;
    /**
     * The TicketingTaxCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TicketingTaxCode;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Percent
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Percent;
    /**
     * The Exempt
     * Meta informations extracted from the WSDL
     * - documentation: "Exempt" is used to indicate whether or not the itinerary is classified as tax exempt | "Exempt" is used to indicate whether or not the itinerary is classified as tax exempt
     * - use: optional
     * @var bool
     */
    public $Exempt;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * The TaxAmount
     * @var float
     */
    public $TaxAmount;
    /**
     * Constructor method for Tax
     * @uses Tax::setAmount()
     * @uses Tax::setTaxCode()
     * @uses Tax::setTaxName()
     * @uses Tax::setTicketingTaxCode()
     * @uses Tax::setText()
     * @uses Tax::setCurrencyCode()
     * @uses Tax::setPercent()
     * @uses Tax::setExempt()
     * @uses Tax::set_()
     * @uses Tax::setId()
     * @uses Tax::setTaxAmount()
     * @param string $amount
     * @param string $taxCode
     * @param string $taxName
     * @param string $ticketingTaxCode
     * @param string $text
     * @param string $currencyCode
     * @param string $percent
     * @param bool $exempt
     * @param string $_
     * @param string $id
     * @param float $taxAmount
     */
    public function __construct($amount = null, $taxCode = null, $taxName = null, $ticketingTaxCode = null, $text = null, $currencyCode = null, $percent = null, $exempt = null, $_ = null, $id = null, $taxAmount = null)
    {
        $this
            ->setAmount($amount)
            ->setTaxCode($taxCode)
            ->setTaxName($taxName)
            ->setTicketingTaxCode($ticketingTaxCode)
            ->setText($text)
            ->setCurrencyCode($currencyCode)
            ->setPercent($percent)
            ->setExempt($exempt)
            ->set_($_)
            ->setId($id)
            ->setTaxAmount($taxAmount);
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tax
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tax
     */
    public function setTaxCode($taxCode = null)
    {
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get TaxName value
     * @return string|null
     */
    public function getTaxName()
    {
        return $this->TaxName;
    }
    /**
     * Set TaxName value
     * @param string $taxName
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tax
     */
    public function setTaxName($taxName = null)
    {
        $this->TaxName = $taxName;
        return $this;
    }
    /**
     * Get TicketingTaxCode value
     * @return string|null
     */
    public function getTicketingTaxCode()
    {
        return $this->TicketingTaxCode;
    }
    /**
     * Set TicketingTaxCode value
     * @param string $ticketingTaxCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tax
     */
    public function setTicketingTaxCode($ticketingTaxCode = null)
    {
        $this->TicketingTaxCode = $ticketingTaxCode;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tax
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tax
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Percent value
     * @return string|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param string $percent
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tax
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get Exempt value
     * @return bool|null
     */
    public function getExempt()
    {
        return $this->Exempt;
    }
    /**
     * Set Exempt value
     * @param bool $exempt
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tax
     */
    public function setExempt($exempt = null)
    {
        $this->Exempt = $exempt;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tax
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tax
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tax
     */
    public function setTaxAmount($taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
