<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Source Structs
 * @subpackage Structs
 */
class Source extends AbstractStructBase
{
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The PseudoCityCode
     * Meta informations extracted from the WSDL
     * - documentation: "PseudoCityCode" is used to return the pseudo-city code associated with the agent sine.
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The ReceivedFrom
     * Meta informations extracted from the WSDL
     * - documentation: "ReceivedFrom" is used to return received from information associated with the particular record. | Same as STL Text.Short - A field of text characters and no other constraints.
     * - use: optional
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $ReceivedFrom;
    /**
     * The RequestorID
     * Meta informations extracted from the WSDL
     * - documentation: "RequestorID" is used to return the ID of the individual who created the particular vehicle reservation. | "RequestorID" is used to return the ID of the individual who created the particular vehicle reservation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string
     */
    public $RequestorID;
    /**
     * The AAA_PseudoCityCode
     * Meta informations extracted from the WSDL
     * - documentation: "AAA_PseudoCityCode" is used to return the AAA pseudo-city code associated with the agent sine
     * - use: optional
     * @var string
     */
    public $AAA_PseudoCityCode;
    /**
     * The CreateDateTime
     * Meta informations extracted from the WSDL
     * - documentation: "CreateDateTime" is used to return the record creation date/time.
     * - use: optional
     * @var string
     */
    public $CreateDateTime;
    /**
     * The CreationAgent
     * Meta informations extracted from the WSDL
     * - documentation: "CreationAgent" is used to return the agent sine associated with the last record update.
     * - use: optional
     * @var string
     */
    public $CreationAgent;
    /**
     * The HomePseudoCityCode
     * Meta informations extracted from the WSDL
     * - documentation: "HomePseudoCityCode" is used to return the home pseudo-city code associated with the agent sine.
     * - use: optional
     * @var string
     */
    public $HomePseudoCityCode;
    /**
     * The LastUpdateDateTime
     * Meta informations extracted from the WSDL
     * - documentation: "LastUpdateDateTime" follows this format: YYYY-MM-DDTHH:MM
     * - use: optional
     * @var string
     */
    public $LastUpdateDateTime;
    /**
     * The SequenceNumber
     * Meta informations extracted from the WSDL
     * - documentation: "SequenceNumber" holds the numeric sequence number number
     * - use: optional
     * @var string
     */
    public $SequenceNumber;
    /**
     * Constructor method for Source
     * @uses Source::setTPA_Extensions()
     * @uses Source::setPseudoCityCode()
     * @uses Source::setReceivedFrom()
     * @uses Source::setRequestorID()
     * @uses Source::setAAA_PseudoCityCode()
     * @uses Source::setCreateDateTime()
     * @uses Source::setCreationAgent()
     * @uses Source::setHomePseudoCityCode()
     * @uses Source::setLastUpdateDateTime()
     * @uses Source::setSequenceNumber()
     * @param \Sabre\CreatePassengerNameRecord\Structs\TPA_Extensions $tPA_Extensions
     * @param string $pseudoCityCode
     * @param string $receivedFrom
     * @param string $requestorID
     * @param string $aAA_PseudoCityCode
     * @param string $createDateTime
     * @param string $creationAgent
     * @param string $homePseudoCityCode
     * @param string $lastUpdateDateTime
     * @param string $sequenceNumber
     */
    public function __construct(\Sabre\CreatePassengerNameRecord\Structs\TPA_Extensions $tPA_Extensions = null, $pseudoCityCode = null, $receivedFrom = null, $requestorID = null, $aAA_PseudoCityCode = null, $createDateTime = null, $creationAgent = null, $homePseudoCityCode = null, $lastUpdateDateTime = null, $sequenceNumber = null)
    {
        $this
            ->setTPA_Extensions($tPA_Extensions)
            ->setPseudoCityCode($pseudoCityCode)
            ->setReceivedFrom($receivedFrom)
            ->setRequestorID($requestorID)
            ->setAAA_PseudoCityCode($aAA_PseudoCityCode)
            ->setCreateDateTime($createDateTime)
            ->setCreationAgent($creationAgent)
            ->setHomePseudoCityCode($homePseudoCityCode)
            ->setLastUpdateDateTime($lastUpdateDateTime)
            ->setSequenceNumber($sequenceNumber);
    }
    /**
     * Get TPA_Extensions value
     * @return \Sabre\CreatePassengerNameRecord\Structs\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \Sabre\CreatePassengerNameRecord\Structs\TPA_Extensions $tPA_Extensions
     * @return \Sabre\CreatePassengerNameRecord\Structs\Source
     */
    public function setTPA_Extensions(\Sabre\CreatePassengerNameRecord\Structs\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Source
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get ReceivedFrom value
     * @return string|null
     */
    public function getReceivedFrom()
    {
        return $this->ReceivedFrom;
    }
    /**
     * Set ReceivedFrom value
     * @param string $receivedFrom
     * @return \Sabre\CreatePassengerNameRecord\Structs\Source
     */
    public function setReceivedFrom($receivedFrom = null)
    {
        $this->ReceivedFrom = $receivedFrom;
        return $this;
    }
    /**
     * Get RequestorID value
     * @return string|null
     */
    public function getRequestorID()
    {
        return $this->RequestorID;
    }
    /**
     * Set RequestorID value
     * @param string $requestorID
     * @return \Sabre\CreatePassengerNameRecord\Structs\Source
     */
    public function setRequestorID($requestorID = null)
    {
        $this->RequestorID = $requestorID;
        return $this;
    }
    /**
     * Get AAA_PseudoCityCode value
     * @return string|null
     */
    public function getAAA_PseudoCityCode()
    {
        return $this->AAA_PseudoCityCode;
    }
    /**
     * Set AAA_PseudoCityCode value
     * @param string $aAA_PseudoCityCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Source
     */
    public function setAAA_PseudoCityCode($aAA_PseudoCityCode = null)
    {
        $this->AAA_PseudoCityCode = $aAA_PseudoCityCode;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \Sabre\CreatePassengerNameRecord\Structs\Source
     */
    public function setCreateDateTime($createDateTime = null)
    {
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get CreationAgent value
     * @return string|null
     */
    public function getCreationAgent()
    {
        return $this->CreationAgent;
    }
    /**
     * Set CreationAgent value
     * @param string $creationAgent
     * @return \Sabre\CreatePassengerNameRecord\Structs\Source
     */
    public function setCreationAgent($creationAgent = null)
    {
        $this->CreationAgent = $creationAgent;
        return $this;
    }
    /**
     * Get HomePseudoCityCode value
     * @return string|null
     */
    public function getHomePseudoCityCode()
    {
        return $this->HomePseudoCityCode;
    }
    /**
     * Set HomePseudoCityCode value
     * @param string $homePseudoCityCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Source
     */
    public function setHomePseudoCityCode($homePseudoCityCode = null)
    {
        $this->HomePseudoCityCode = $homePseudoCityCode;
        return $this;
    }
    /**
     * Get LastUpdateDateTime value
     * @return string|null
     */
    public function getLastUpdateDateTime()
    {
        return $this->LastUpdateDateTime;
    }
    /**
     * Set LastUpdateDateTime value
     * @param string $lastUpdateDateTime
     * @return \Sabre\CreatePassengerNameRecord\Structs\Source
     */
    public function setLastUpdateDateTime($lastUpdateDateTime = null)
    {
        $this->LastUpdateDateTime = $lastUpdateDateTime;
        return $this;
    }
    /**
     * Get SequenceNumber value
     * @return string|null
     */
    public function getSequenceNumber()
    {
        return $this->SequenceNumber;
    }
    /**
     * Set SequenceNumber value
     * @param string $sequenceNumber
     * @return \Sabre\CreatePassengerNameRecord\Structs\Source
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        $this->SequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\Source
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
