<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SolutionInformation Structs
 * @subpackage Structs
 */
class SolutionInformation extends AbstractStructBase
{
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The RequiresRebook
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RequiresRebook;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SegmentNumber;
    /**
     * The ServiceFeeCurrency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ServiceFeeCurrency;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The TicketNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TicketNumber;
    /**
     * The TotalAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TotalAmount;
    /**
     * The TotalServiceFeeAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TotalServiceFeeAmount;
    /**
     * The TotalServiceTax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TotalServiceTax;
    /**
     * The SolutionSequenceNmbr
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SolutionSequenceNmbr;
    /**
     * Constructor method for SolutionInformation
     * @uses SolutionInformation::setCurrencyCode()
     * @uses SolutionInformation::setRequiresRebook()
     * @uses SolutionInformation::setSegmentNumber()
     * @uses SolutionInformation::setServiceFeeCurrency()
     * @uses SolutionInformation::setText()
     * @uses SolutionInformation::setTicketNumber()
     * @uses SolutionInformation::setTotalAmount()
     * @uses SolutionInformation::setTotalServiceFeeAmount()
     * @uses SolutionInformation::setTotalServiceTax()
     * @uses SolutionInformation::setSolutionSequenceNmbr()
     * @param string $currencyCode
     * @param string $requiresRebook
     * @param string[] $segmentNumber
     * @param string $serviceFeeCurrency
     * @param string[] $text
     * @param string $ticketNumber
     * @param string $totalAmount
     * @param string $totalServiceFeeAmount
     * @param string $totalServiceTax
     * @param string $solutionSequenceNmbr
     */
    public function __construct($currencyCode = null, $requiresRebook = null, array $segmentNumber = array(), $serviceFeeCurrency = null, array $text = array(), $ticketNumber = null, $totalAmount = null, $totalServiceFeeAmount = null, $totalServiceTax = null, $solutionSequenceNmbr = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->setRequiresRebook($requiresRebook)
            ->setSegmentNumber($segmentNumber)
            ->setServiceFeeCurrency($serviceFeeCurrency)
            ->setText($text)
            ->setTicketNumber($ticketNumber)
            ->setTotalAmount($totalAmount)
            ->setTotalServiceFeeAmount($totalServiceFeeAmount)
            ->setTotalServiceTax($totalServiceTax)
            ->setSolutionSequenceNmbr($solutionSequenceNmbr);
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\SolutionInformation
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get RequiresRebook value
     * @return string|null
     */
    public function getRequiresRebook()
    {
        return $this->RequiresRebook;
    }
    /**
     * Set RequiresRebook value
     * @param string $requiresRebook
     * @return \Sabre\CreatePassengerNameRecord\Structs\SolutionInformation
     */
    public function setRequiresRebook($requiresRebook = null)
    {
        $this->RequiresRebook = $requiresRebook;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string[]|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @throws \InvalidArgumentException
     * @param string[] $segmentNumber
     * @return \Sabre\CreatePassengerNameRecord\Structs\SolutionInformation
     */
    public function setSegmentNumber(array $segmentNumber = array())
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Add item to SegmentNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\SolutionInformation
     */
    public function addToSegmentNumber($item)
    {
        $this->SegmentNumber[] = $item;
        return $this;
    }
    /**
     * Get ServiceFeeCurrency value
     * @return string|null
     */
    public function getServiceFeeCurrency()
    {
        return $this->ServiceFeeCurrency;
    }
    /**
     * Set ServiceFeeCurrency value
     * @param string $serviceFeeCurrency
     * @return \Sabre\CreatePassengerNameRecord\Structs\SolutionInformation
     */
    public function setServiceFeeCurrency($serviceFeeCurrency = null)
    {
        $this->ServiceFeeCurrency = $serviceFeeCurrency;
        return $this;
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\CreatePassengerNameRecord\Structs\SolutionInformation
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\SolutionInformation
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param string $ticketNumber
     * @return \Sabre\CreatePassengerNameRecord\Structs\SolutionInformation
     */
    public function setTicketNumber($ticketNumber = null)
    {
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return string|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param string $totalAmount
     * @return \Sabre\CreatePassengerNameRecord\Structs\SolutionInformation
     */
    public function setTotalAmount($totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get TotalServiceFeeAmount value
     * @return string|null
     */
    public function getTotalServiceFeeAmount()
    {
        return $this->TotalServiceFeeAmount;
    }
    /**
     * Set TotalServiceFeeAmount value
     * @param string $totalServiceFeeAmount
     * @return \Sabre\CreatePassengerNameRecord\Structs\SolutionInformation
     */
    public function setTotalServiceFeeAmount($totalServiceFeeAmount = null)
    {
        $this->TotalServiceFeeAmount = $totalServiceFeeAmount;
        return $this;
    }
    /**
     * Get TotalServiceTax value
     * @return string|null
     */
    public function getTotalServiceTax()
    {
        return $this->TotalServiceTax;
    }
    /**
     * Set TotalServiceTax value
     * @param string $totalServiceTax
     * @return \Sabre\CreatePassengerNameRecord\Structs\SolutionInformation
     */
    public function setTotalServiceTax($totalServiceTax = null)
    {
        $this->TotalServiceTax = $totalServiceTax;
        return $this;
    }
    /**
     * Get SolutionSequenceNmbr value
     * @return string|null
     */
    public function getSolutionSequenceNmbr()
    {
        return $this->SolutionSequenceNmbr;
    }
    /**
     * Set SolutionSequenceNmbr value
     * @param string $solutionSequenceNmbr
     * @return \Sabre\CreatePassengerNameRecord\Structs\SolutionInformation
     */
    public function setSolutionSequenceNmbr($solutionSequenceNmbr = null)
    {
        $this->SolutionSequenceNmbr = $solutionSequenceNmbr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\SolutionInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
