<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedisplayReservation Structs
 * @subpackage Structs
 */
class RedisplayReservation extends AbstractStructBase
{
    /**
     * The NumAttempts
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $NumAttempts;
    /**
     * The WaitInterval
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $WaitInterval;
    /**
     * Constructor method for RedisplayReservation
     * @uses RedisplayReservation::setNumAttempts()
     * @uses RedisplayReservation::setWaitInterval()
     * @param string $numAttempts
     * @param string $waitInterval
     */
    public function __construct($numAttempts = null, $waitInterval = null)
    {
        $this
            ->setNumAttempts($numAttempts)
            ->setWaitInterval($waitInterval);
    }
    /**
     * Get NumAttempts value
     * @return string
     */
    public function getNumAttempts()
    {
        return $this->NumAttempts;
    }
    /**
     * Set NumAttempts value
     * @param string $numAttempts
     * @return \Sabre\CreatePassengerNameRecord\Structs\RedisplayReservation
     */
    public function setNumAttempts($numAttempts = null)
    {
        $this->NumAttempts = $numAttempts;
        return $this;
    }
    /**
     * Get WaitInterval value
     * @return string
     */
    public function getWaitInterval()
    {
        return $this->WaitInterval;
    }
    /**
     * Set WaitInterval value
     * @param string $waitInterval
     * @return \Sabre\CreatePassengerNameRecord\Structs\RedisplayReservation
     */
    public function setWaitInterval($waitInterval = null)
    {
        $this->WaitInterval = $waitInterval;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\RedisplayReservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
