<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueInfo Structs
 * Meta informations extracted from the WSDL
 * - documentation: Holds Queue placement details
 * @subpackage Structs
 */
class QueueInfo extends AbstractStructBase
{
    /**
     * The QueueIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 3
     * @var \Sabre\CreatePassengerNameRecord\Structs\QueueIdentifier[]
     */
    public $QueueIdentifier;
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 6
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\UniqueID[]
     */
    public $UniqueID;
    /**
     * The Placement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Placement[]
     */
    public $Placement;
    /**
     * Constructor method for QueueInfo
     * @uses QueueInfo::setQueueIdentifier()
     * @uses QueueInfo::setUniqueID()
     * @uses QueueInfo::setPlacement()
     * @param \Sabre\CreatePassengerNameRecord\Structs\QueueIdentifier[] $queueIdentifier
     * @param \Sabre\CreatePassengerNameRecord\Structs\UniqueID[] $uniqueID
     * @param \Sabre\CreatePassengerNameRecord\Structs\Placement[] $placement
     */
    public function __construct(array $queueIdentifier = array(), array $uniqueID = array(), array $placement = array())
    {
        $this
            ->setQueueIdentifier($queueIdentifier)
            ->setUniqueID($uniqueID)
            ->setPlacement($placement);
    }
    /**
     * Get QueueIdentifier value
     * @return \Sabre\CreatePassengerNameRecord\Structs\QueueIdentifier[]|null
     */
    public function getQueueIdentifier()
    {
        return $this->QueueIdentifier;
    }
    /**
     * Set QueueIdentifier value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\QueueIdentifier[] $queueIdentifier
     * @return \Sabre\CreatePassengerNameRecord\Structs\QueueInfo
     */
    public function setQueueIdentifier(array $queueIdentifier = array())
    {
        $this->QueueIdentifier = $queueIdentifier;
        return $this;
    }
    /**
     * Add item to QueueIdentifier value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\QueueIdentifier $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\QueueInfo
     */
    public function addToQueueIdentifier(\Sabre\CreatePassengerNameRecord\Structs\QueueIdentifier $item)
    {
        $this->QueueIdentifier[] = $item;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \Sabre\CreatePassengerNameRecord\Structs\UniqueID[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\UniqueID[] $uniqueID
     * @return \Sabre\CreatePassengerNameRecord\Structs\QueueInfo
     */
    public function setUniqueID(array $uniqueID = array())
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\UniqueID $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\QueueInfo
     */
    public function addToUniqueID(\Sabre\CreatePassengerNameRecord\Structs\UniqueID $item)
    {
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get Placement value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Placement[]|null
     */
    public function getPlacement()
    {
        return $this->Placement;
    }
    /**
     * Set Placement value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Placement[] $placement
     * @return \Sabre\CreatePassengerNameRecord\Structs\QueueInfo
     */
    public function setPlacement(array $placement = array())
    {
        $this->Placement = $placement;
        return $this;
    }
    /**
     * Add item to Placement value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Placement $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\QueueInfo
     */
    public function addToPlacement(\Sabre\CreatePassengerNameRecord\Structs\Placement $item)
    {
        $this->Placement[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\QueueInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
