<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueIdentifier Structs
 * @subpackage Structs
 */
class QueueIdentifier extends AbstractStructBase
{
    /**
     * The PrefatoryInstructionCode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PrefatoryInstructionCode;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * The PseudoCityCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * Constructor method for QueueIdentifier
     * @uses QueueIdentifier::setPrefatoryInstructionCode()
     * @uses QueueIdentifier::setNumber()
     * @uses QueueIdentifier::setPseudoCityCode()
     * @uses QueueIdentifier::setName()
     * @param string $prefatoryInstructionCode
     * @param string $number
     * @param string $pseudoCityCode
     * @param string $name
     */
    public function __construct($prefatoryInstructionCode = null, $number = null, $pseudoCityCode = null, $name = null)
    {
        $this
            ->setPrefatoryInstructionCode($prefatoryInstructionCode)
            ->setNumber($number)
            ->setPseudoCityCode($pseudoCityCode)
            ->setName($name);
    }
    /**
     * Get PrefatoryInstructionCode value
     * @return string
     */
    public function getPrefatoryInstructionCode()
    {
        return $this->PrefatoryInstructionCode;
    }
    /**
     * Set PrefatoryInstructionCode value
     * @param string $prefatoryInstructionCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\QueueIdentifier
     */
    public function setPrefatoryInstructionCode($prefatoryInstructionCode = null)
    {
        $this->PrefatoryInstructionCode = $prefatoryInstructionCode;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Sabre\CreatePassengerNameRecord\Structs\QueueIdentifier
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\QueueIdentifier
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\CreatePassengerNameRecord\Structs\QueueIdentifier
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\QueueIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
