<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductDetailsType Structs
 * @subpackage Structs
 */
class ProductDetailsType extends AbstractStructBase
{
    /**
     * The ProductName
     * @var \Sabre\CreatePassengerNameRecord\Structs\ProductNameType
     */
    public $ProductName;
    /**
     * The Hotel
     * @var \Sabre\CreatePassengerNameRecord\Structs\HotelProductType
     */
    public $Hotel;
    /**
     * The GroundTransportation
     * @var \Sabre\CreatePassengerNameRecord\Structs\GroundTransportationType
     */
    public $GroundTransportation;
    /**
     * The Rail
     * @var \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public $Rail;
    /**
     * The ExternalSystemReference
     * Meta informations extracted from the WSDL
     * - documentation: Hold reference ID given by external system/application which can be used to reference to product item that is in the external system
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\ExternalSystemReferenceType[]
     */
    public $ExternalSystemReference;
    /**
     * The TransactionInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\TransactionInfo
     */
    public $TransactionInfo;
    /**
     * The CO2Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\CO2ValueType
     */
    public $CO2Value;
    /**
     * The productCategory
     * Meta informations extracted from the WSDL
     * - documentation: eg. TruTrip, passive, high level source/type
     * @var string
     */
    public $productCategory;
    /**
     * The productType
     * @var string
     */
    public $productType;
    /**
     * The vendorCode
     * @var string
     */
    public $vendorCode;
    /**
     * The statusCode
     * @var string
     */
    public $statusCode;
    /**
     * The previousStatusCode
     * @var string
     */
    public $previousStatusCode;
    /**
     * The startPoint
     * @var string
     */
    public $startPoint;
    /**
     * The startDateTime
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $startDateTime;
    /**
     * The endPoint
     * @var string
     */
    public $endPoint;
    /**
     * The endDateTime
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $endDateTime;
    /**
     * The normalizedIndicator
     * Meta informations extracted from the WSDL
     * - documentation: when equals to "true" means this data has been normalized with Normalized Service
     * @var bool
     */
    public $normalizedIndicator;
    /**
     * Constructor method for ProductDetailsType
     * @uses ProductDetailsType::setProductName()
     * @uses ProductDetailsType::setHotel()
     * @uses ProductDetailsType::setGroundTransportation()
     * @uses ProductDetailsType::setRail()
     * @uses ProductDetailsType::setExternalSystemReference()
     * @uses ProductDetailsType::setTransactionInfo()
     * @uses ProductDetailsType::setCO2Value()
     * @uses ProductDetailsType::setProductCategory()
     * @uses ProductDetailsType::setProductType()
     * @uses ProductDetailsType::setVendorCode()
     * @uses ProductDetailsType::setStatusCode()
     * @uses ProductDetailsType::setPreviousStatusCode()
     * @uses ProductDetailsType::setStartPoint()
     * @uses ProductDetailsType::setStartDateTime()
     * @uses ProductDetailsType::setEndPoint()
     * @uses ProductDetailsType::setEndDateTime()
     * @uses ProductDetailsType::setNormalizedIndicator()
     * @param \Sabre\CreatePassengerNameRecord\Structs\ProductNameType $productName
     * @param \Sabre\CreatePassengerNameRecord\Structs\HotelProductType $hotel
     * @param \Sabre\CreatePassengerNameRecord\Structs\GroundTransportationType $groundTransportation
     * @param \Sabre\CreatePassengerNameRecord\Structs\RailType $rail
     * @param \Sabre\CreatePassengerNameRecord\Structs\ExternalSystemReferenceType[] $externalSystemReference
     * @param \Sabre\CreatePassengerNameRecord\Structs\TransactionInfo $transactionInfo
     * @param \Sabre\CreatePassengerNameRecord\Structs\CO2ValueType $cO2Value
     * @param string $productCategory
     * @param string $productType
     * @param string $vendorCode
     * @param string $statusCode
     * @param string $previousStatusCode
     * @param string $startPoint
     * @param string $startDateTime
     * @param string $endPoint
     * @param string $endDateTime
     * @param bool $normalizedIndicator
     */
    public function __construct(\Sabre\CreatePassengerNameRecord\Structs\ProductNameType $productName = null, \Sabre\CreatePassengerNameRecord\Structs\HotelProductType $hotel = null, \Sabre\CreatePassengerNameRecord\Structs\GroundTransportationType $groundTransportation = null, \Sabre\CreatePassengerNameRecord\Structs\RailType $rail = null, array $externalSystemReference = array(), \Sabre\CreatePassengerNameRecord\Structs\TransactionInfo $transactionInfo = null, \Sabre\CreatePassengerNameRecord\Structs\CO2ValueType $cO2Value = null, $productCategory = null, $productType = null, $vendorCode = null, $statusCode = null, $previousStatusCode = null, $startPoint = null, $startDateTime = null, $endPoint = null, $endDateTime = null, $normalizedIndicator = null)
    {
        $this
            ->setProductName($productName)
            ->setHotel($hotel)
            ->setGroundTransportation($groundTransportation)
            ->setRail($rail)
            ->setExternalSystemReference($externalSystemReference)
            ->setTransactionInfo($transactionInfo)
            ->setCO2Value($cO2Value)
            ->setProductCategory($productCategory)
            ->setProductType($productType)
            ->setVendorCode($vendorCode)
            ->setStatusCode($statusCode)
            ->setPreviousStatusCode($previousStatusCode)
            ->setStartPoint($startPoint)
            ->setStartDateTime($startDateTime)
            ->setEndPoint($endPoint)
            ->setEndDateTime($endDateTime)
            ->setNormalizedIndicator($normalizedIndicator);
    }
    /**
     * Get ProductName value
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductNameType|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param \Sabre\CreatePassengerNameRecord\Structs\ProductNameType $productName
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function setProductName(\Sabre\CreatePassengerNameRecord\Structs\ProductNameType $productName = null)
    {
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get Hotel value
     * @return \Sabre\CreatePassengerNameRecord\Structs\HotelProductType|null
     */
    public function getHotel()
    {
        return $this->Hotel;
    }
    /**
     * Set Hotel value
     * @param \Sabre\CreatePassengerNameRecord\Structs\HotelProductType $hotel
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function setHotel(\Sabre\CreatePassengerNameRecord\Structs\HotelProductType $hotel = null)
    {
        $this->Hotel = $hotel;
        return $this;
    }
    /**
     * Get GroundTransportation value
     * @return \Sabre\CreatePassengerNameRecord\Structs\GroundTransportationType|null
     */
    public function getGroundTransportation()
    {
        return $this->GroundTransportation;
    }
    /**
     * Set GroundTransportation value
     * @param \Sabre\CreatePassengerNameRecord\Structs\GroundTransportationType $groundTransportation
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function setGroundTransportation(\Sabre\CreatePassengerNameRecord\Structs\GroundTransportationType $groundTransportation = null)
    {
        $this->GroundTransportation = $groundTransportation;
        return $this;
    }
    /**
     * Get Rail value
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType|null
     */
    public function getRail()
    {
        return $this->Rail;
    }
    /**
     * Set Rail value
     * @param \Sabre\CreatePassengerNameRecord\Structs\RailType $rail
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function setRail(\Sabre\CreatePassengerNameRecord\Structs\RailType $rail = null)
    {
        $this->Rail = $rail;
        return $this;
    }
    /**
     * Get ExternalSystemReference value
     * @return \Sabre\CreatePassengerNameRecord\Structs\ExternalSystemReferenceType[]|null
     */
    public function getExternalSystemReference()
    {
        return $this->ExternalSystemReference;
    }
    /**
     * Set ExternalSystemReference value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\ExternalSystemReferenceType[] $externalSystemReference
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function setExternalSystemReference(array $externalSystemReference = array())
    {
        $this->ExternalSystemReference = $externalSystemReference;
        return $this;
    }
    /**
     * Add item to ExternalSystemReference value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\ExternalSystemReferenceType $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function addToExternalSystemReference(\Sabre\CreatePassengerNameRecord\Structs\ExternalSystemReferenceType $item)
    {
        $this->ExternalSystemReference[] = $item;
        return $this;
    }
    /**
     * Get TransactionInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\TransactionInfo|null
     */
    public function getTransactionInfo()
    {
        return $this->TransactionInfo;
    }
    /**
     * Set TransactionInfo value
     * @param \Sabre\CreatePassengerNameRecord\Structs\TransactionInfo $transactionInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function setTransactionInfo(\Sabre\CreatePassengerNameRecord\Structs\TransactionInfo $transactionInfo = null)
    {
        $this->TransactionInfo = $transactionInfo;
        return $this;
    }
    /**
     * Get CO2Value value
     * @return \Sabre\CreatePassengerNameRecord\Structs\CO2ValueType|null
     */
    public function getCO2Value()
    {
        return $this->CO2Value;
    }
    /**
     * Set CO2Value value
     * @param \Sabre\CreatePassengerNameRecord\Structs\CO2ValueType $cO2Value
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function setCO2Value(\Sabre\CreatePassengerNameRecord\Structs\CO2ValueType $cO2Value = null)
    {
        $this->CO2Value = $cO2Value;
        return $this;
    }
    /**
     * Get productCategory value
     * @return string|null
     */
    public function getProductCategory()
    {
        return $this->productCategory;
    }
    /**
     * Set productCategory value
     * @param string $productCategory
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function setProductCategory($productCategory = null)
    {
        $this->productCategory = $productCategory;
        return $this;
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @param string $productType
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function setProductType($productType = null)
    {
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get vendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->vendorCode;
    }
    /**
     * Set vendorCode value
     * @param string $vendorCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function setVendorCode($vendorCode = null)
    {
        $this->vendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get statusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->statusCode;
    }
    /**
     * Set statusCode value
     * @param string $statusCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function setStatusCode($statusCode = null)
    {
        $this->statusCode = $statusCode;
        return $this;
    }
    /**
     * Get previousStatusCode value
     * @return string|null
     */
    public function getPreviousStatusCode()
    {
        return $this->previousStatusCode;
    }
    /**
     * Set previousStatusCode value
     * @param string $previousStatusCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function setPreviousStatusCode($previousStatusCode = null)
    {
        $this->previousStatusCode = $previousStatusCode;
        return $this;
    }
    /**
     * Get startPoint value
     * @return string|null
     */
    public function getStartPoint()
    {
        return $this->startPoint;
    }
    /**
     * Set startPoint value
     * @param string $startPoint
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function setStartPoint($startPoint = null)
    {
        $this->startPoint = $startPoint;
        return $this;
    }
    /**
     * Get startDateTime value
     * @return string|null
     */
    public function getStartDateTime()
    {
        return $this->startDateTime;
    }
    /**
     * Set startDateTime value
     * @param string $startDateTime
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function setStartDateTime($startDateTime = null)
    {
        $this->startDateTime = $startDateTime;
        return $this;
    }
    /**
     * Get endPoint value
     * @return string|null
     */
    public function getEndPoint()
    {
        return $this->endPoint;
    }
    /**
     * Set endPoint value
     * @param string $endPoint
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function setEndPoint($endPoint = null)
    {
        $this->endPoint = $endPoint;
        return $this;
    }
    /**
     * Get endDateTime value
     * @return string|null
     */
    public function getEndDateTime()
    {
        return $this->endDateTime;
    }
    /**
     * Set endDateTime value
     * @param string $endDateTime
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function setEndDateTime($endDateTime = null)
    {
        $this->endDateTime = $endDateTime;
        return $this;
    }
    /**
     * Get normalizedIndicator value
     * @return bool|null
     */
    public function getNormalizedIndicator()
    {
        return $this->normalizedIndicator;
    }
    /**
     * Set normalizedIndicator value
     * @param bool $normalizedIndicator
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public function setNormalizedIndicator($normalizedIndicator = null)
    {
        $this->normalizedIndicator = $normalizedIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
