<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonNameType Structs
 * @subpackage Structs
 */
class PersonNameType extends AbstractStructBase
{
    /**
     * The Prefix
     * Meta informations extracted from the WSDL
     * - documentation: Salutation of honorific. (e.g., Mr. Mrs., Ms., Miss, Dr.)
     * - minOccurs: 0
     * @var string
     */
    public $Prefix;
    /**
     * The Given
     * Meta informations extracted from the WSDL
     * - documentation: Given name, first name or names
     * - minOccurs: 0
     * @var string
     */
    public $Given;
    /**
     * The Middle
     * Meta informations extracted from the WSDL
     * - documentation: The middle name of the person name
     * - minOccurs: 0
     * @var string
     */
    public $Middle;
    /**
     * The Surname
     * Meta informations extracted from the WSDL
     * - documentation: Family name aslo known as last name.
     * @var string
     */
    public $Surname;
    /**
     * The Suffix
     * Meta informations extracted from the WSDL
     * - documentation: Hold various name suffixes and letters (e.g. Jr., Sr., III, Ret., Esq.).
     * - minOccurs: 0
     * @var string
     */
    public $Suffix;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The PreferredFirstName
     * Meta informations extracted from the WSDL
     * - documentation: Any preferred names for first name used instead of GivenName
     * - minOccurs: 0
     * @var string
     */
    public $PreferredFirstName;
    /**
     * The PreferredSurname
     * Meta informations extracted from the WSDL
     * - documentation: Any preferred names for last names used instead of surname
     * - minOccurs: 0
     * @var string
     */
    public $PreferredSurname;
    /**
     * Constructor method for PersonNameType
     * @uses PersonNameType::setPrefix()
     * @uses PersonNameType::setGiven()
     * @uses PersonNameType::setMiddle()
     * @uses PersonNameType::setSurname()
     * @uses PersonNameType::setSuffix()
     * @uses PersonNameType::setType()
     * @uses PersonNameType::setPreferredFirstName()
     * @uses PersonNameType::setPreferredSurname()
     * @param string $prefix
     * @param string $given
     * @param string $middle
     * @param string $surname
     * @param string $suffix
     * @param string $type
     * @param string $preferredFirstName
     * @param string $preferredSurname
     */
    public function __construct($prefix = null, $given = null, $middle = null, $surname = null, $suffix = null, $type = null, $preferredFirstName = null, $preferredSurname = null)
    {
        $this
            ->setPrefix($prefix)
            ->setGiven($given)
            ->setMiddle($middle)
            ->setSurname($surname)
            ->setSuffix($suffix)
            ->setType($type)
            ->setPreferredFirstName($preferredFirstName)
            ->setPreferredSurname($preferredSurname);
    }
    /**
     * Get Prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->Prefix;
    }
    /**
     * Set Prefix value
     * @param string $prefix
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonNameType
     */
    public function setPrefix($prefix = null)
    {
        $this->Prefix = $prefix;
        return $this;
    }
    /**
     * Get Given value
     * @return string|null
     */
    public function getGiven()
    {
        return $this->Given;
    }
    /**
     * Set Given value
     * @param string $given
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonNameType
     */
    public function setGiven($given = null)
    {
        $this->Given = $given;
        return $this;
    }
    /**
     * Get Middle value
     * @return string|null
     */
    public function getMiddle()
    {
        return $this->Middle;
    }
    /**
     * Set Middle value
     * @param string $middle
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonNameType
     */
    public function setMiddle($middle = null)
    {
        $this->Middle = $middle;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonNameType
     */
    public function setSurname($surname = null)
    {
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get Suffix value
     * @return string|null
     */
    public function getSuffix()
    {
        return $this->Suffix;
    }
    /**
     * Set Suffix value
     * @param string $suffix
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonNameType
     */
    public function setSuffix($suffix = null)
    {
        $this->Suffix = $suffix;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonNameType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get PreferredFirstName value
     * @return string|null
     */
    public function getPreferredFirstName()
    {
        return $this->PreferredFirstName;
    }
    /**
     * Set PreferredFirstName value
     * @param string $preferredFirstName
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonNameType
     */
    public function setPreferredFirstName($preferredFirstName = null)
    {
        $this->PreferredFirstName = $preferredFirstName;
        return $this;
    }
    /**
     * Get PreferredSurname value
     * @return string|null
     */
    public function getPreferredSurname()
    {
        return $this->PreferredSurname;
    }
    /**
     * Set PreferredSurname value
     * @param string $preferredSurname
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonNameType
     */
    public function setPreferredSurname($preferredSurname = null)
    {
        $this->PreferredSurname = $preferredSurname;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
