<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Installment Structs
 * @subpackage Structs
 */
class Installment extends AbstractStructBase
{
    /**
     * The Count
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Count;
    /**
     * The PayLaterReferenceNumber
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PayLaterReferenceNumber;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Value;
    /**
     * Constructor method for Installment
     * @uses Installment::setCount()
     * @uses Installment::setPayLaterReferenceNumber()
     * @uses Installment::setValue()
     * @param string $count
     * @param string $payLaterReferenceNumber
     * @param string $value
     */
    public function __construct($count = null, $payLaterReferenceNumber = null, $value = null)
    {
        $this
            ->setCount($count)
            ->setPayLaterReferenceNumber($payLaterReferenceNumber)
            ->setValue($value);
    }
    /**
     * Get Count value
     * @return string
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param string $count
     * @return \Sabre\CreatePassengerNameRecord\Structs\Installment
     */
    public function setCount($count = null)
    {
        $this->Count = $count;
        return $this;
    }
    /**
     * Get PayLaterReferenceNumber value
     * @return string
     */
    public function getPayLaterReferenceNumber()
    {
        return $this->PayLaterReferenceNumber;
    }
    /**
     * Set PayLaterReferenceNumber value
     * @param string $payLaterReferenceNumber
     * @return \Sabre\CreatePassengerNameRecord\Structs\Installment
     */
    public function setPayLaterReferenceNumber($payLaterReferenceNumber = null)
    {
        $this->PayLaterReferenceNumber = $payLaterReferenceNumber;
        return $this;
    }
    /**
     * Get Value value
     * @return string
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Installment
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\Installment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
