<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSegment Structs
 * @subpackage Structs
 */
class FlightSegment extends AbstractStructBase
{
    /**
     * The DestinationLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\DestinationLocation
     */
    public $DestinationLocation;
    /**
     * The Equipment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Equipment
     */
    public $Equipment;
    /**
     * The MarketingAirline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\MarketingAirline
     */
    public $MarketingAirline;
    /**
     * The MarriageGrp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MarriageGrp;
    /**
     * The OperatingAirline
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\OperatingAirline[]
     */
    public $OperatingAirline;
    /**
     * The OriginLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\OriginLocation
     */
    public $OriginLocation;
    /**
     * The ArrivalDateTime
     * Meta informations extracted from the WSDL
     * - documentation: "ArrivalDateTime" is used to return the scheduled arrival date/time associated with the particular flight segment. Please note that updated information is provided via .../Air/UpdatedArrivalTime if applicable. "ArrivalDateTime"
     * follows this format: MM-DDTHH:MM
     * - use: optional
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The BrandID
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrandID;
    /**
     * The DepartureDateTime
     * Meta informations extracted from the WSDL
     * - documentation: "DepartureDateTime" is used to return the time and date of flight departure associated with the particular flight segment. "DepartureDateTime" follows this format: MM:DDTHH:MM | "DepartureDateTime" is used to return the scheduled
     * departure date/time associated with the particular flight segment. Please note that updated information is provided via .../Air/UpdatedDepartureTime if applicable. "DepartureDateTime" follows this format: YYYY-MM-DDTHH:MM | DepartureDateTime" is used
     * to return the departure date/time associated with the particular segment. "DepartureDateTime" follows this format: MM:DD | A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats:
     * "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - use: optional
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - documentation: "FlightNumber" is used to return the flight number associated with the particular flight segment. | "FlightNumber" is used to return the flight number associated with the particular flight segment. | "FlightNumber" is used to return
     * the flight number associated with the particular segment. | "FlightNumber" is used to return the flight number associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $FlightNumber;
    /**
     * The NumberInParty
     * Meta informations extracted from the WSDL
     * - documentation: "NumberInParty" is used to return the number of passengers associated with the particular hotel segment.
     * - use: optional
     * @var string
     */
    public $NumberInParty;
    /**
     * The ResBookDesigCode
     * Meta informations extracted from the WSDL
     * - documentation: "ResBookDesigCode" is used to return the booking class associated with the particular flight segment. | "ResBookDesigCode" is used to return the booking class associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: "Status" is used to return the status code associated with the particular itinerary segment. | "Status" is used to return the status code associated with the particular itinerary segment.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The ArrivalAirport
     * @var \Sabre\CreatePassengerNameRecord\Structs\ArrivalAirport
     */
    public $ArrivalAirport;
    /**
     * The DepartureAirport
     * @var \Sabre\CreatePassengerNameRecord\Structs\DepartureAirport
     */
    public $DepartureAirport;
    /**
     * The FareBreakInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\FareBreakInfo
     */
    public $FareBreakInfo;
    /**
     * The HiddenStops
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\HiddenStops
     */
    public $HiddenStops;
    /**
     * The ForceConnectionInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ForceConnectionInd;
    /**
     * The ForceStopOverInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ForceStopOverInd;
    /**
     * The eTicket
     * Meta informations extracted from the WSDL
     * - documentation: "eTicket" is used to indicate whether or not the particular flight segment is eTicket-eligible.
     * - use: optional
     * @var bool
     */
    public $eTicket;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - documentation: "SegmentNumber" is used to return the internal order segment number that was used to price the segments. | "SegmentNumber" is used to return the itinerary segment number.
     * - use: optional
     * @var string
     */
    public $SegmentNumber;
    /**
     * The BaggageAllowance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\BaggageAllowance
     */
    public $BaggageAllowance;
    /**
     * The FareBasis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\FareBasis
     */
    public $FareBasis;
    /**
     * The ValidityDates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\ValidityDates
     */
    public $ValidityDates;
    /**
     * The ConnectionInd
     * Meta informations extracted from the WSDL
     * - documentation: "ConnectionInd" is used to return the connection indicator associated with the particular flight segment. | "ConnectionInd" is used to return the connection indicator associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $ConnectionInd;
    /**
     * The BSG_Record
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\BSG_Record
     */
    public $BSG_Record;
    /**
     * The CheckInAirline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\CheckInAirline
     */
    public $CheckInAirline;
    /**
     * The CodeshareRecord
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\CodeshareRecord
     */
    public $CodeshareRecord;
    /**
     * The MarketingCodeshareRecord
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\MarketingCodeshareRecord
     */
    public $MarketingCodeshareRecord;
    /**
     * The Meal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Meal[]
     */
    public $Meal;
    /**
     * The OperatingAirlineRecord
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\OperatingAirlineRecord
     */
    public $OperatingAirlineRecord;
    /**
     * The PartnerCarrier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\PartnerCarrier
     */
    public $PartnerCarrier;
    /**
     * The SupplierRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\SupplierRef
     */
    public $SupplierRef;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return miscellaneous free text-based information.
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The BSGIndicator
     * Meta informations extracted from the WSDL
     * - documentation: "BSGIndicator" is used to indicate he flight segment has a BSG PNR
     * - minOccurs: 0
     * @var string
     */
    public $BSGIndicator;
    /**
     * The UpdatedArrivalTime
     * Meta informations extracted from the WSDL
     * - documentation: "UpdatedArrivalTime" is used to return updated arrival information if applicable. "UpdatedArrivalTime" follows this format: MM-DDTHH:MM
     * - minOccurs: 0
     * @var string
     */
    public $UpdatedArrivalTime;
    /**
     * The UpdatedDepartureTime
     * Meta informations extracted from the WSDL
     * - documentation: "UpdatedDepartureTime" is used to return updated departure information if applicable. "UpdatedDepartureTime" follows this format: MM-DDTHH:MM
     * - minOccurs: 0
     * @var string
     */
    public $UpdatedDepartureTime;
    /**
     * The AirMilesFlown
     * Meta informations extracted from the WSDL
     * - documentation: "AirMilesFlown" is used to return the air miles flown associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $AirMilesFlown;
    /**
     * The DayOfWeekInd
     * Meta informations extracted from the WSDL
     * - documentation: "DayOfWeekInd" is used to return the day of the week indicator.
     * - use: optional
     * @var string
     */
    public $DayOfWeekInd;
    /**
     * The ElapsedTime
     * Meta informations extracted from the WSDL
     * - documentation: "ElapsedTime" is used to return the elapsed time associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $ElapsedTime;
    /**
     * The SmokingAllowed
     * Meta informations extracted from the WSDL
     * - documentation: "SmokingAllowed" is used to indicate whether or not smoking is permitted on the particular flight segment.
     * - use: optional
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The SpecialMeal
     * Meta informations extracted from the WSDL
     * - documentation: "SpecialMeal" is used to indicate whether or not a special meal is associated with the particular flight segment.
     * - use: optional
     * @var bool
     */
    public $SpecialMeal;
    /**
     * The StopQuantity
     * Meta informations extracted from the WSDL
     * - documentation: "StopQuantity" is used to return the number of stops associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $StopQuantity;
    /**
     * The IsPast
     * Meta informations extracted from the WSDL
     * - documentation: It returns information if current segment is past or not. Attribute is populated based on FlightSegment - @DepartureDateTime, FlightSegment - OriginLocation - @LocationCode.
     * - use: optional
     * @var bool
     */
    public $IsPast;
    /**
     * Constructor method for FlightSegment
     * @uses FlightSegment::setDestinationLocation()
     * @uses FlightSegment::setEquipment()
     * @uses FlightSegment::setMarketingAirline()
     * @uses FlightSegment::setMarriageGrp()
     * @uses FlightSegment::setOperatingAirline()
     * @uses FlightSegment::setOriginLocation()
     * @uses FlightSegment::setArrivalDateTime()
     * @uses FlightSegment::setBrandID()
     * @uses FlightSegment::setDepartureDateTime()
     * @uses FlightSegment::setFlightNumber()
     * @uses FlightSegment::setNumberInParty()
     * @uses FlightSegment::setResBookDesigCode()
     * @uses FlightSegment::setStatus()
     * @uses FlightSegment::setArrivalAirport()
     * @uses FlightSegment::setDepartureAirport()
     * @uses FlightSegment::setFareBreakInfo()
     * @uses FlightSegment::setHiddenStops()
     * @uses FlightSegment::setForceConnectionInd()
     * @uses FlightSegment::setForceStopOverInd()
     * @uses FlightSegment::setETicket()
     * @uses FlightSegment::setSegmentNumber()
     * @uses FlightSegment::setBaggageAllowance()
     * @uses FlightSegment::setFareBasis()
     * @uses FlightSegment::setValidityDates()
     * @uses FlightSegment::setConnectionInd()
     * @uses FlightSegment::setBSG_Record()
     * @uses FlightSegment::setCheckInAirline()
     * @uses FlightSegment::setCodeshareRecord()
     * @uses FlightSegment::setMarketingCodeshareRecord()
     * @uses FlightSegment::setMeal()
     * @uses FlightSegment::setOperatingAirlineRecord()
     * @uses FlightSegment::setPartnerCarrier()
     * @uses FlightSegment::setSupplierRef()
     * @uses FlightSegment::setText()
     * @uses FlightSegment::setBSGIndicator()
     * @uses FlightSegment::setUpdatedArrivalTime()
     * @uses FlightSegment::setUpdatedDepartureTime()
     * @uses FlightSegment::setAirMilesFlown()
     * @uses FlightSegment::setDayOfWeekInd()
     * @uses FlightSegment::setElapsedTime()
     * @uses FlightSegment::setSmokingAllowed()
     * @uses FlightSegment::setSpecialMeal()
     * @uses FlightSegment::setStopQuantity()
     * @uses FlightSegment::setIsPast()
     * @param \Sabre\CreatePassengerNameRecord\Structs\DestinationLocation $destinationLocation
     * @param \Sabre\CreatePassengerNameRecord\Structs\Equipment $equipment
     * @param \Sabre\CreatePassengerNameRecord\Structs\MarketingAirline $marketingAirline
     * @param string $marriageGrp
     * @param \Sabre\CreatePassengerNameRecord\Structs\OperatingAirline[] $operatingAirline
     * @param \Sabre\CreatePassengerNameRecord\Structs\OriginLocation $originLocation
     * @param string $arrivalDateTime
     * @param string $brandID
     * @param string $departureDateTime
     * @param string $flightNumber
     * @param string $numberInParty
     * @param string $resBookDesigCode
     * @param string $status
     * @param \Sabre\CreatePassengerNameRecord\Structs\ArrivalAirport $arrivalAirport
     * @param \Sabre\CreatePassengerNameRecord\Structs\DepartureAirport $departureAirport
     * @param \Sabre\CreatePassengerNameRecord\Structs\FareBreakInfo $fareBreakInfo
     * @param \Sabre\CreatePassengerNameRecord\Structs\HiddenStops $hiddenStops
     * @param bool $forceConnectionInd
     * @param bool $forceStopOverInd
     * @param bool $eTicket
     * @param string $segmentNumber
     * @param \Sabre\CreatePassengerNameRecord\Structs\BaggageAllowance $baggageAllowance
     * @param \Sabre\CreatePassengerNameRecord\Structs\FareBasis $fareBasis
     * @param \Sabre\CreatePassengerNameRecord\Structs\ValidityDates $validityDates
     * @param string $connectionInd
     * @param \Sabre\CreatePassengerNameRecord\Structs\BSG_Record $bSG_Record
     * @param \Sabre\CreatePassengerNameRecord\Structs\CheckInAirline $checkInAirline
     * @param \Sabre\CreatePassengerNameRecord\Structs\CodeshareRecord $codeshareRecord
     * @param \Sabre\CreatePassengerNameRecord\Structs\MarketingCodeshareRecord $marketingCodeshareRecord
     * @param \Sabre\CreatePassengerNameRecord\Structs\Meal[] $meal
     * @param \Sabre\CreatePassengerNameRecord\Structs\OperatingAirlineRecord $operatingAirlineRecord
     * @param \Sabre\CreatePassengerNameRecord\Structs\PartnerCarrier $partnerCarrier
     * @param \Sabre\CreatePassengerNameRecord\Structs\SupplierRef $supplierRef
     * @param string $text
     * @param string $bSGIndicator
     * @param string $updatedArrivalTime
     * @param string $updatedDepartureTime
     * @param string $airMilesFlown
     * @param string $dayOfWeekInd
     * @param string $elapsedTime
     * @param bool $smokingAllowed
     * @param bool $specialMeal
     * @param string $stopQuantity
     * @param bool $isPast
     */
    public function __construct(\Sabre\CreatePassengerNameRecord\Structs\DestinationLocation $destinationLocation = null, \Sabre\CreatePassengerNameRecord\Structs\Equipment $equipment = null, \Sabre\CreatePassengerNameRecord\Structs\MarketingAirline $marketingAirline = null, $marriageGrp = null, array $operatingAirline = array(), \Sabre\CreatePassengerNameRecord\Structs\OriginLocation $originLocation = null, $arrivalDateTime = null, $brandID = null, $departureDateTime = null, $flightNumber = null, $numberInParty = null, $resBookDesigCode = null, $status = null, \Sabre\CreatePassengerNameRecord\Structs\ArrivalAirport $arrivalAirport = null, \Sabre\CreatePassengerNameRecord\Structs\DepartureAirport $departureAirport = null, \Sabre\CreatePassengerNameRecord\Structs\FareBreakInfo $fareBreakInfo = null, \Sabre\CreatePassengerNameRecord\Structs\HiddenStops $hiddenStops = null, $forceConnectionInd = null, $forceStopOverInd = null, $eTicket = null, $segmentNumber = null, \Sabre\CreatePassengerNameRecord\Structs\BaggageAllowance $baggageAllowance = null, \Sabre\CreatePassengerNameRecord\Structs\FareBasis $fareBasis = null, \Sabre\CreatePassengerNameRecord\Structs\ValidityDates $validityDates = null, $connectionInd = null, \Sabre\CreatePassengerNameRecord\Structs\BSG_Record $bSG_Record = null, \Sabre\CreatePassengerNameRecord\Structs\CheckInAirline $checkInAirline = null, \Sabre\CreatePassengerNameRecord\Structs\CodeshareRecord $codeshareRecord = null, \Sabre\CreatePassengerNameRecord\Structs\MarketingCodeshareRecord $marketingCodeshareRecord = null, array $meal = array(), \Sabre\CreatePassengerNameRecord\Structs\OperatingAirlineRecord $operatingAirlineRecord = null, \Sabre\CreatePassengerNameRecord\Structs\PartnerCarrier $partnerCarrier = null, \Sabre\CreatePassengerNameRecord\Structs\SupplierRef $supplierRef = null, $text = null, $bSGIndicator = null, $updatedArrivalTime = null, $updatedDepartureTime = null, $airMilesFlown = null, $dayOfWeekInd = null, $elapsedTime = null, $smokingAllowed = null, $specialMeal = null, $stopQuantity = null, $isPast = null)
    {
        $this
            ->setDestinationLocation($destinationLocation)
            ->setEquipment($equipment)
            ->setMarketingAirline($marketingAirline)
            ->setMarriageGrp($marriageGrp)
            ->setOperatingAirline($operatingAirline)
            ->setOriginLocation($originLocation)
            ->setArrivalDateTime($arrivalDateTime)
            ->setBrandID($brandID)
            ->setDepartureDateTime($departureDateTime)
            ->setFlightNumber($flightNumber)
            ->setNumberInParty($numberInParty)
            ->setResBookDesigCode($resBookDesigCode)
            ->setStatus($status)
            ->setArrivalAirport($arrivalAirport)
            ->setDepartureAirport($departureAirport)
            ->setFareBreakInfo($fareBreakInfo)
            ->setHiddenStops($hiddenStops)
            ->setForceConnectionInd($forceConnectionInd)
            ->setForceStopOverInd($forceStopOverInd)
            ->setETicket($eTicket)
            ->setSegmentNumber($segmentNumber)
            ->setBaggageAllowance($baggageAllowance)
            ->setFareBasis($fareBasis)
            ->setValidityDates($validityDates)
            ->setConnectionInd($connectionInd)
            ->setBSG_Record($bSG_Record)
            ->setCheckInAirline($checkInAirline)
            ->setCodeshareRecord($codeshareRecord)
            ->setMarketingCodeshareRecord($marketingCodeshareRecord)
            ->setMeal($meal)
            ->setOperatingAirlineRecord($operatingAirlineRecord)
            ->setPartnerCarrier($partnerCarrier)
            ->setSupplierRef($supplierRef)
            ->setText($text)
            ->setBSGIndicator($bSGIndicator)
            ->setUpdatedArrivalTime($updatedArrivalTime)
            ->setUpdatedDepartureTime($updatedDepartureTime)
            ->setAirMilesFlown($airMilesFlown)
            ->setDayOfWeekInd($dayOfWeekInd)
            ->setElapsedTime($elapsedTime)
            ->setSmokingAllowed($smokingAllowed)
            ->setSpecialMeal($specialMeal)
            ->setStopQuantity($stopQuantity)
            ->setIsPast($isPast);
    }
    /**
     * Get DestinationLocation value
     * @return \Sabre\CreatePassengerNameRecord\Structs\DestinationLocation|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \Sabre\CreatePassengerNameRecord\Structs\DestinationLocation $destinationLocation
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setDestinationLocation(\Sabre\CreatePassengerNameRecord\Structs\DestinationLocation $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get Equipment value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Equipment|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Equipment $equipment
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setEquipment(\Sabre\CreatePassengerNameRecord\Structs\Equipment $equipment = null)
    {
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Get MarketingAirline value
     * @return \Sabre\CreatePassengerNameRecord\Structs\MarketingAirline|null
     */
    public function getMarketingAirline()
    {
        return $this->MarketingAirline;
    }
    /**
     * Set MarketingAirline value
     * @param \Sabre\CreatePassengerNameRecord\Structs\MarketingAirline $marketingAirline
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setMarketingAirline(\Sabre\CreatePassengerNameRecord\Structs\MarketingAirline $marketingAirline = null)
    {
        $this->MarketingAirline = $marketingAirline;
        return $this;
    }
    /**
     * Get MarriageGrp value
     * @return string|null
     */
    public function getMarriageGrp()
    {
        return $this->MarriageGrp;
    }
    /**
     * Set MarriageGrp value
     * @uses \Sabre\CreatePassengerNameRecord\Enums\MarriageGrp::valueIsValid()
     * @uses \Sabre\CreatePassengerNameRecord\Enums\MarriageGrp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $marriageGrp
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setMarriageGrp($marriageGrp = null)
    {
        $this->MarriageGrp = $marriageGrp;
        return $this;
    }
    /**
     * Get OperatingAirline value
     * @return \Sabre\CreatePassengerNameRecord\Structs\OperatingAirline[]|null
     */
    public function getOperatingAirline()
    {
        return $this->OperatingAirline;
    }
    /**
     * Set OperatingAirline value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\OperatingAirline[] $operatingAirline
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setOperatingAirline(array $operatingAirline = array())
    {
        $this->OperatingAirline = $operatingAirline;
        return $this;
    }
    /**
     * Add item to OperatingAirline value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\OperatingAirline $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function addToOperatingAirline(\Sabre\CreatePassengerNameRecord\Structs\OperatingAirline $item)
    {
        $this->OperatingAirline[] = $item;
        return $this;
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\CreatePassengerNameRecord\Structs\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \Sabre\CreatePassengerNameRecord\Structs\OriginLocation $originLocation
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setOriginLocation(\Sabre\CreatePassengerNameRecord\Structs\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get BrandID value
     * @return string|null
     */
    public function getBrandID()
    {
        return $this->BrandID;
    }
    /**
     * Set BrandID value
     * @param string $brandID
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setBrandID($brandID = null)
    {
        $this->BrandID = $brandID;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setFlightNumber($flightNumber = null)
    {
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get NumberInParty value
     * @return string|null
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param string $numberInParty
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setNumberInParty($numberInParty = null)
    {
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return \Sabre\CreatePassengerNameRecord\Structs\ArrivalAirport|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param \Sabre\CreatePassengerNameRecord\Structs\ArrivalAirport $arrivalAirport
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setArrivalAirport(\Sabre\CreatePassengerNameRecord\Structs\ArrivalAirport $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return \Sabre\CreatePassengerNameRecord\Structs\DepartureAirport|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \Sabre\CreatePassengerNameRecord\Structs\DepartureAirport $departureAirport
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setDepartureAirport(\Sabre\CreatePassengerNameRecord\Structs\DepartureAirport $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get FareBreakInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\FareBreakInfo|null
     */
    public function getFareBreakInfo()
    {
        return $this->FareBreakInfo;
    }
    /**
     * Set FareBreakInfo value
     * @param \Sabre\CreatePassengerNameRecord\Structs\FareBreakInfo $fareBreakInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setFareBreakInfo(\Sabre\CreatePassengerNameRecord\Structs\FareBreakInfo $fareBreakInfo = null)
    {
        $this->FareBreakInfo = $fareBreakInfo;
        return $this;
    }
    /**
     * Get HiddenStops value
     * @return \Sabre\CreatePassengerNameRecord\Structs\HiddenStops|null
     */
    public function getHiddenStops()
    {
        return $this->HiddenStops;
    }
    /**
     * Set HiddenStops value
     * @param \Sabre\CreatePassengerNameRecord\Structs\HiddenStops $hiddenStops
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setHiddenStops(\Sabre\CreatePassengerNameRecord\Structs\HiddenStops $hiddenStops = null)
    {
        $this->HiddenStops = $hiddenStops;
        return $this;
    }
    /**
     * Get ForceConnectionInd value
     * @return bool|null
     */
    public function getForceConnectionInd()
    {
        return $this->ForceConnectionInd;
    }
    /**
     * Set ForceConnectionInd value
     * @param bool $forceConnectionInd
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setForceConnectionInd($forceConnectionInd = null)
    {
        $this->ForceConnectionInd = $forceConnectionInd;
        return $this;
    }
    /**
     * Get ForceStopOverInd value
     * @return bool|null
     */
    public function getForceStopOverInd()
    {
        return $this->ForceStopOverInd;
    }
    /**
     * Set ForceStopOverInd value
     * @param bool $forceStopOverInd
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setForceStopOverInd($forceStopOverInd = null)
    {
        $this->ForceStopOverInd = $forceStopOverInd;
        return $this;
    }
    /**
     * Get eTicket value
     * @return bool|null
     */
    public function getETicket()
    {
        return $this->eTicket;
    }
    /**
     * Set eTicket value
     * @param bool $eTicket
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setETicket($eTicket = null)
    {
        $this->eTicket = $eTicket;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param string $segmentNumber
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get BaggageAllowance value
     * @return \Sabre\CreatePassengerNameRecord\Structs\BaggageAllowance|null
     */
    public function getBaggageAllowance()
    {
        return $this->BaggageAllowance;
    }
    /**
     * Set BaggageAllowance value
     * @param \Sabre\CreatePassengerNameRecord\Structs\BaggageAllowance $baggageAllowance
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setBaggageAllowance(\Sabre\CreatePassengerNameRecord\Structs\BaggageAllowance $baggageAllowance = null)
    {
        $this->BaggageAllowance = $baggageAllowance;
        return $this;
    }
    /**
     * Get FareBasis value
     * @return \Sabre\CreatePassengerNameRecord\Structs\FareBasis|null
     */
    public function getFareBasis()
    {
        return $this->FareBasis;
    }
    /**
     * Set FareBasis value
     * @param \Sabre\CreatePassengerNameRecord\Structs\FareBasis $fareBasis
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setFareBasis(\Sabre\CreatePassengerNameRecord\Structs\FareBasis $fareBasis = null)
    {
        $this->FareBasis = $fareBasis;
        return $this;
    }
    /**
     * Get ValidityDates value
     * @return \Sabre\CreatePassengerNameRecord\Structs\ValidityDates|null
     */
    public function getValidityDates()
    {
        return $this->ValidityDates;
    }
    /**
     * Set ValidityDates value
     * @param \Sabre\CreatePassengerNameRecord\Structs\ValidityDates $validityDates
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setValidityDates(\Sabre\CreatePassengerNameRecord\Structs\ValidityDates $validityDates = null)
    {
        $this->ValidityDates = $validityDates;
        return $this;
    }
    /**
     * Get ConnectionInd value
     * @return string|null
     */
    public function getConnectionInd()
    {
        return $this->ConnectionInd;
    }
    /**
     * Set ConnectionInd value
     * @param string $connectionInd
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setConnectionInd($connectionInd = null)
    {
        $this->ConnectionInd = $connectionInd;
        return $this;
    }
    /**
     * Get BSG_Record value
     * @return \Sabre\CreatePassengerNameRecord\Structs\BSG_Record|null
     */
    public function getBSG_Record()
    {
        return $this->BSG_Record;
    }
    /**
     * Set BSG_Record value
     * @param \Sabre\CreatePassengerNameRecord\Structs\BSG_Record $bSG_Record
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setBSG_Record(\Sabre\CreatePassengerNameRecord\Structs\BSG_Record $bSG_Record = null)
    {
        $this->BSG_Record = $bSG_Record;
        return $this;
    }
    /**
     * Get CheckInAirline value
     * @return \Sabre\CreatePassengerNameRecord\Structs\CheckInAirline|null
     */
    public function getCheckInAirline()
    {
        return $this->CheckInAirline;
    }
    /**
     * Set CheckInAirline value
     * @param \Sabre\CreatePassengerNameRecord\Structs\CheckInAirline $checkInAirline
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setCheckInAirline(\Sabre\CreatePassengerNameRecord\Structs\CheckInAirline $checkInAirline = null)
    {
        $this->CheckInAirline = $checkInAirline;
        return $this;
    }
    /**
     * Get CodeshareRecord value
     * @return \Sabre\CreatePassengerNameRecord\Structs\CodeshareRecord|null
     */
    public function getCodeshareRecord()
    {
        return $this->CodeshareRecord;
    }
    /**
     * Set CodeshareRecord value
     * @param \Sabre\CreatePassengerNameRecord\Structs\CodeshareRecord $codeshareRecord
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setCodeshareRecord(\Sabre\CreatePassengerNameRecord\Structs\CodeshareRecord $codeshareRecord = null)
    {
        $this->CodeshareRecord = $codeshareRecord;
        return $this;
    }
    /**
     * Get MarketingCodeshareRecord value
     * @return \Sabre\CreatePassengerNameRecord\Structs\MarketingCodeshareRecord|null
     */
    public function getMarketingCodeshareRecord()
    {
        return $this->MarketingCodeshareRecord;
    }
    /**
     * Set MarketingCodeshareRecord value
     * @param \Sabre\CreatePassengerNameRecord\Structs\MarketingCodeshareRecord $marketingCodeshareRecord
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setMarketingCodeshareRecord(\Sabre\CreatePassengerNameRecord\Structs\MarketingCodeshareRecord $marketingCodeshareRecord = null)
    {
        $this->MarketingCodeshareRecord = $marketingCodeshareRecord;
        return $this;
    }
    /**
     * Get Meal value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Meal[]|null
     */
    public function getMeal()
    {
        return $this->Meal;
    }
    /**
     * Set Meal value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Meal[] $meal
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setMeal(array $meal = array())
    {
        $this->Meal = $meal;
        return $this;
    }
    /**
     * Add item to Meal value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Meal $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function addToMeal(\Sabre\CreatePassengerNameRecord\Structs\Meal $item)
    {
        $this->Meal[] = $item;
        return $this;
    }
    /**
     * Get OperatingAirlineRecord value
     * @return \Sabre\CreatePassengerNameRecord\Structs\OperatingAirlineRecord|null
     */
    public function getOperatingAirlineRecord()
    {
        return $this->OperatingAirlineRecord;
    }
    /**
     * Set OperatingAirlineRecord value
     * @param \Sabre\CreatePassengerNameRecord\Structs\OperatingAirlineRecord $operatingAirlineRecord
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setOperatingAirlineRecord(\Sabre\CreatePassengerNameRecord\Structs\OperatingAirlineRecord $operatingAirlineRecord = null)
    {
        $this->OperatingAirlineRecord = $operatingAirlineRecord;
        return $this;
    }
    /**
     * Get PartnerCarrier value
     * @return \Sabre\CreatePassengerNameRecord\Structs\PartnerCarrier|null
     */
    public function getPartnerCarrier()
    {
        return $this->PartnerCarrier;
    }
    /**
     * Set PartnerCarrier value
     * @param \Sabre\CreatePassengerNameRecord\Structs\PartnerCarrier $partnerCarrier
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setPartnerCarrier(\Sabre\CreatePassengerNameRecord\Structs\PartnerCarrier $partnerCarrier = null)
    {
        $this->PartnerCarrier = $partnerCarrier;
        return $this;
    }
    /**
     * Get SupplierRef value
     * @return \Sabre\CreatePassengerNameRecord\Structs\SupplierRef|null
     */
    public function getSupplierRef()
    {
        return $this->SupplierRef;
    }
    /**
     * Set SupplierRef value
     * @param \Sabre\CreatePassengerNameRecord\Structs\SupplierRef $supplierRef
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setSupplierRef(\Sabre\CreatePassengerNameRecord\Structs\SupplierRef $supplierRef = null)
    {
        $this->SupplierRef = $supplierRef;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get BSGIndicator value
     * @return string|null
     */
    public function getBSGIndicator()
    {
        return $this->BSGIndicator;
    }
    /**
     * Set BSGIndicator value
     * @param string $bSGIndicator
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setBSGIndicator($bSGIndicator = null)
    {
        $this->BSGIndicator = $bSGIndicator;
        return $this;
    }
    /**
     * Get UpdatedArrivalTime value
     * @return string|null
     */
    public function getUpdatedArrivalTime()
    {
        return $this->UpdatedArrivalTime;
    }
    /**
     * Set UpdatedArrivalTime value
     * @param string $updatedArrivalTime
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setUpdatedArrivalTime($updatedArrivalTime = null)
    {
        $this->UpdatedArrivalTime = $updatedArrivalTime;
        return $this;
    }
    /**
     * Get UpdatedDepartureTime value
     * @return string|null
     */
    public function getUpdatedDepartureTime()
    {
        return $this->UpdatedDepartureTime;
    }
    /**
     * Set UpdatedDepartureTime value
     * @param string $updatedDepartureTime
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setUpdatedDepartureTime($updatedDepartureTime = null)
    {
        $this->UpdatedDepartureTime = $updatedDepartureTime;
        return $this;
    }
    /**
     * Get AirMilesFlown value
     * @return string|null
     */
    public function getAirMilesFlown()
    {
        return $this->AirMilesFlown;
    }
    /**
     * Set AirMilesFlown value
     * @param string $airMilesFlown
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setAirMilesFlown($airMilesFlown = null)
    {
        $this->AirMilesFlown = $airMilesFlown;
        return $this;
    }
    /**
     * Get DayOfWeekInd value
     * @return string|null
     */
    public function getDayOfWeekInd()
    {
        return $this->DayOfWeekInd;
    }
    /**
     * Set DayOfWeekInd value
     * @param string $dayOfWeekInd
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setDayOfWeekInd($dayOfWeekInd = null)
    {
        $this->DayOfWeekInd = $dayOfWeekInd;
        return $this;
    }
    /**
     * Get ElapsedTime value
     * @return string|null
     */
    public function getElapsedTime()
    {
        return $this->ElapsedTime;
    }
    /**
     * Set ElapsedTime value
     * @param string $elapsedTime
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setElapsedTime($elapsedTime = null)
    {
        $this->ElapsedTime = $elapsedTime;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setSmokingAllowed($smokingAllowed = null)
    {
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get SpecialMeal value
     * @return bool|null
     */
    public function getSpecialMeal()
    {
        return $this->SpecialMeal;
    }
    /**
     * Set SpecialMeal value
     * @param bool $specialMeal
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setSpecialMeal($specialMeal = null)
    {
        $this->SpecialMeal = $specialMeal;
        return $this;
    }
    /**
     * Get StopQuantity value
     * @return string|null
     */
    public function getStopQuantity()
    {
        return $this->StopQuantity;
    }
    /**
     * Set StopQuantity value
     * @param string $stopQuantity
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setStopQuantity($stopQuantity = null)
    {
        $this->StopQuantity = $stopQuantity;
        return $this;
    }
    /**
     * Get IsPast value
     * @return bool|null
     */
    public function getIsPast()
    {
        return $this->IsPast;
    }
    /**
     * Set IsPast value
     * @param bool $isPast
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public function setIsPast($isPast = null)
    {
        $this->IsPast = $isPast;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
