<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeeInformation Structs
 * @subpackage Structs
 */
class FeeInformation extends AbstractStructBase
{
    /**
     * The CreditCardFOP_MatchingBin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreditCardFOP_MatchingBin;
    /**
     * The CreditCard_ResidualAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CreditCard_ResidualAmount;
    /**
     * The MaximumServiceFeeAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MaximumServiceFeeAmount;
    /**
     * The OB_FeeTicketTotalFareAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OB_FeeTicketTotalFareAmount;
    /**
     * The ServiceFeePercentage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ServiceFeePercentage;
    /**
     * The TaxAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TaxAmount;
    /**
     * The TaxID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TaxID;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return the ticketing fee amount.
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The NumFees
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $NumFees;
    /**
     * The NameNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $NameNumber;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SegmentNumber;
    /**
     * The AccountData
     * Meta informations extracted from the WSDL
     * - documentation: "AccountData" is used to return ticketing fee account-related information.
     * - use: optional
     * @var string
     */
    public $AccountData;
    /**
     * The FunctionCode
     * Meta informations extracted from the WSDL
     * - documentation: "FunctionCode" is used to return the ticketing fee function code.
     * - use: optional
     * @var string
     */
    public $FunctionCode;
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - documentation: "ServiceType" is used to return the ticketing fee service type.
     * - use: optional
     * @var string
     */
    public $ServiceType;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The DisplayOnOutputInd
     * Meta informations extracted from the WSDL
     * - documentation: "DisplayOnOutputInd" is used to is used to indicate whether or not the fee is displayed on output.
     * - use: optional
     * @var string
     */
    public $DisplayOnOutputInd;
    /**
     * The GuaranteeType
     * Meta informations extracted from the WSDL
     * - documentation: "GuaranteeType" is used to return the ticketing fee guarantee type.
     * - use: optional
     * @var string
     */
    public $GuaranteeType;
    /**
     * The NonCommissionInd
     * Meta informations extracted from the WSDL
     * - documentation: "NonCommissionInd" is used to is used to indicate whether or not the fee is commission eligible.
     * - use: optional
     * @var string
     */
    public $NonCommissionInd;
    /**
     * The NonRefundableInd
     * Meta informations extracted from the WSDL
     * - documentation: "NonRefundableInd" is used to is used to indicate whether or not the fee is refundable.
     * - use: optional
     * @var string
     */
    public $NonRefundableInd;
    /**
     * The OnlineInterlineService
     * Meta informations extracted from the WSDL
     * - documentation: "OnlineInterlineService" is used to is used to return online/interline-related information.
     * - use: optional
     * @var string
     */
    public $OnlineInterlineService;
    /**
     * The CurrenyCode
     * Meta informations extracted from the WSDL
     * - documentation: Ob Fee Currency Code.
     * - use: optional
     * @var string
     */
    public $CurrenyCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Ob Fee Description.
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The WaiverCode
     * Meta informations extracted from the WSDL
     * - documentation: "WaiverCode" is used to return the Waiver code.
     * - use: optional
     * @var string
     */
    public $WaiverCode;
    /**
     * Constructor method for FeeInformation
     * @uses FeeInformation::setCreditCardFOP_MatchingBin()
     * @uses FeeInformation::setCreditCard_ResidualAmount()
     * @uses FeeInformation::setMaximumServiceFeeAmount()
     * @uses FeeInformation::setOB_FeeTicketTotalFareAmount()
     * @uses FeeInformation::setServiceFeePercentage()
     * @uses FeeInformation::setTaxAmount()
     * @uses FeeInformation::setTaxID()
     * @uses FeeInformation::setAmount()
     * @uses FeeInformation::setCode()
     * @uses FeeInformation::setNumFees()
     * @uses FeeInformation::setNameNumber()
     * @uses FeeInformation::setSegmentNumber()
     * @uses FeeInformation::setAccountData()
     * @uses FeeInformation::setFunctionCode()
     * @uses FeeInformation::setServiceType()
     * @uses FeeInformation::set_()
     * @uses FeeInformation::setDisplayOnOutputInd()
     * @uses FeeInformation::setGuaranteeType()
     * @uses FeeInformation::setNonCommissionInd()
     * @uses FeeInformation::setNonRefundableInd()
     * @uses FeeInformation::setOnlineInterlineService()
     * @uses FeeInformation::setCurrenyCode()
     * @uses FeeInformation::setDescription()
     * @uses FeeInformation::setWaiverCode()
     * @param string $creditCardFOP_MatchingBin
     * @param float $creditCard_ResidualAmount
     * @param string $maximumServiceFeeAmount
     * @param string $oB_FeeTicketTotalFareAmount
     * @param string $serviceFeePercentage
     * @param string[] $taxAmount
     * @param string[] $taxID
     * @param string $amount
     * @param string $code
     * @param string $numFees
     * @param string $nameNumber
     * @param string $segmentNumber
     * @param string $accountData
     * @param string $functionCode
     * @param string $serviceType
     * @param string $_
     * @param string $displayOnOutputInd
     * @param string $guaranteeType
     * @param string $nonCommissionInd
     * @param string $nonRefundableInd
     * @param string $onlineInterlineService
     * @param string $currenyCode
     * @param string $description
     * @param string $waiverCode
     */
    public function __construct($creditCardFOP_MatchingBin = null, $creditCard_ResidualAmount = null, $maximumServiceFeeAmount = null, $oB_FeeTicketTotalFareAmount = null, $serviceFeePercentage = null, array $taxAmount = array(), array $taxID = array(), $amount = null, $code = null, $numFees = null, $nameNumber = null, $segmentNumber = null, $accountData = null, $functionCode = null, $serviceType = null, $_ = null, $displayOnOutputInd = null, $guaranteeType = null, $nonCommissionInd = null, $nonRefundableInd = null, $onlineInterlineService = null, $currenyCode = null, $description = null, $waiverCode = null)
    {
        $this
            ->setCreditCardFOP_MatchingBin($creditCardFOP_MatchingBin)
            ->setCreditCard_ResidualAmount($creditCard_ResidualAmount)
            ->setMaximumServiceFeeAmount($maximumServiceFeeAmount)
            ->setOB_FeeTicketTotalFareAmount($oB_FeeTicketTotalFareAmount)
            ->setServiceFeePercentage($serviceFeePercentage)
            ->setTaxAmount($taxAmount)
            ->setTaxID($taxID)
            ->setAmount($amount)
            ->setCode($code)
            ->setNumFees($numFees)
            ->setNameNumber($nameNumber)
            ->setSegmentNumber($segmentNumber)
            ->setAccountData($accountData)
            ->setFunctionCode($functionCode)
            ->setServiceType($serviceType)
            ->set_($_)
            ->setDisplayOnOutputInd($displayOnOutputInd)
            ->setGuaranteeType($guaranteeType)
            ->setNonCommissionInd($nonCommissionInd)
            ->setNonRefundableInd($nonRefundableInd)
            ->setOnlineInterlineService($onlineInterlineService)
            ->setCurrenyCode($currenyCode)
            ->setDescription($description)
            ->setWaiverCode($waiverCode);
    }
    /**
     * Get CreditCardFOP_MatchingBin value
     * @return string|null
     */
    public function getCreditCardFOP_MatchingBin()
    {
        return $this->CreditCardFOP_MatchingBin;
    }
    /**
     * Set CreditCardFOP_MatchingBin value
     * @param string $creditCardFOP_MatchingBin
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setCreditCardFOP_MatchingBin($creditCardFOP_MatchingBin = null)
    {
        $this->CreditCardFOP_MatchingBin = $creditCardFOP_MatchingBin;
        return $this;
    }
    /**
     * Get CreditCard_ResidualAmount value
     * @return float|null
     */
    public function getCreditCard_ResidualAmount()
    {
        return $this->CreditCard_ResidualAmount;
    }
    /**
     * Set CreditCard_ResidualAmount value
     * @param float $creditCard_ResidualAmount
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setCreditCard_ResidualAmount($creditCard_ResidualAmount = null)
    {
        $this->CreditCard_ResidualAmount = $creditCard_ResidualAmount;
        return $this;
    }
    /**
     * Get MaximumServiceFeeAmount value
     * @return string|null
     */
    public function getMaximumServiceFeeAmount()
    {
        return $this->MaximumServiceFeeAmount;
    }
    /**
     * Set MaximumServiceFeeAmount value
     * @param string $maximumServiceFeeAmount
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setMaximumServiceFeeAmount($maximumServiceFeeAmount = null)
    {
        $this->MaximumServiceFeeAmount = $maximumServiceFeeAmount;
        return $this;
    }
    /**
     * Get OB_FeeTicketTotalFareAmount value
     * @return string|null
     */
    public function getOB_FeeTicketTotalFareAmount()
    {
        return $this->OB_FeeTicketTotalFareAmount;
    }
    /**
     * Set OB_FeeTicketTotalFareAmount value
     * @param string $oB_FeeTicketTotalFareAmount
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setOB_FeeTicketTotalFareAmount($oB_FeeTicketTotalFareAmount = null)
    {
        $this->OB_FeeTicketTotalFareAmount = $oB_FeeTicketTotalFareAmount;
        return $this;
    }
    /**
     * Get ServiceFeePercentage value
     * @return string|null
     */
    public function getServiceFeePercentage()
    {
        return $this->ServiceFeePercentage;
    }
    /**
     * Set ServiceFeePercentage value
     * @param string $serviceFeePercentage
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setServiceFeePercentage($serviceFeePercentage = null)
    {
        $this->ServiceFeePercentage = $serviceFeePercentage;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return string[]|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @throws \InvalidArgumentException
     * @param string[] $taxAmount
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setTaxAmount(array $taxAmount = array())
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Add item to TaxAmount value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function addToTaxAmount($item)
    {
        $this->TaxAmount[] = $item;
        return $this;
    }
    /**
     * Get TaxID value
     * @return string[]|null
     */
    public function getTaxID()
    {
        return $this->TaxID;
    }
    /**
     * Set TaxID value
     * @throws \InvalidArgumentException
     * @param string[] $taxID
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setTaxID(array $taxID = array())
    {
        $this->TaxID = $taxID;
        return $this;
    }
    /**
     * Add item to TaxID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function addToTaxID($item)
    {
        $this->TaxID[] = $item;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get NumFees value
     * @return string|null
     */
    public function getNumFees()
    {
        return $this->NumFees;
    }
    /**
     * Set NumFees value
     * @param string $numFees
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setNumFees($numFees = null)
    {
        $this->NumFees = $numFees;
        return $this;
    }
    /**
     * Get NameNumber value
     * @return string|null
     */
    public function getNameNumber()
    {
        return $this->NameNumber;
    }
    /**
     * Set NameNumber value
     * @param string $nameNumber
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setNameNumber($nameNumber = null)
    {
        $this->NameNumber = $nameNumber;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param string $segmentNumber
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get AccountData value
     * @return string|null
     */
    public function getAccountData()
    {
        return $this->AccountData;
    }
    /**
     * Set AccountData value
     * @param string $accountData
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setAccountData($accountData = null)
    {
        $this->AccountData = $accountData;
        return $this;
    }
    /**
     * Get FunctionCode value
     * @return string|null
     */
    public function getFunctionCode()
    {
        return $this->FunctionCode;
    }
    /**
     * Set FunctionCode value
     * @param string $functionCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setFunctionCode($functionCode = null)
    {
        $this->FunctionCode = $functionCode;
        return $this;
    }
    /**
     * Get ServiceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @param string $serviceType
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setServiceType($serviceType = null)
    {
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get DisplayOnOutputInd value
     * @return string|null
     */
    public function getDisplayOnOutputInd()
    {
        return $this->DisplayOnOutputInd;
    }
    /**
     * Set DisplayOnOutputInd value
     * @param string $displayOnOutputInd
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setDisplayOnOutputInd($displayOnOutputInd = null)
    {
        $this->DisplayOnOutputInd = $displayOnOutputInd;
        return $this;
    }
    /**
     * Get GuaranteeType value
     * @return string|null
     */
    public function getGuaranteeType()
    {
        return $this->GuaranteeType;
    }
    /**
     * Set GuaranteeType value
     * @param string $guaranteeType
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setGuaranteeType($guaranteeType = null)
    {
        $this->GuaranteeType = $guaranteeType;
        return $this;
    }
    /**
     * Get NonCommissionInd value
     * @return string|null
     */
    public function getNonCommissionInd()
    {
        return $this->NonCommissionInd;
    }
    /**
     * Set NonCommissionInd value
     * @param string $nonCommissionInd
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setNonCommissionInd($nonCommissionInd = null)
    {
        $this->NonCommissionInd = $nonCommissionInd;
        return $this;
    }
    /**
     * Get NonRefundableInd value
     * @return string|null
     */
    public function getNonRefundableInd()
    {
        return $this->NonRefundableInd;
    }
    /**
     * Set NonRefundableInd value
     * @param string $nonRefundableInd
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setNonRefundableInd($nonRefundableInd = null)
    {
        $this->NonRefundableInd = $nonRefundableInd;
        return $this;
    }
    /**
     * Get OnlineInterlineService value
     * @return string|null
     */
    public function getOnlineInterlineService()
    {
        return $this->OnlineInterlineService;
    }
    /**
     * Set OnlineInterlineService value
     * @param string $onlineInterlineService
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setOnlineInterlineService($onlineInterlineService = null)
    {
        $this->OnlineInterlineService = $onlineInterlineService;
        return $this;
    }
    /**
     * Get CurrenyCode value
     * @return string|null
     */
    public function getCurrenyCode()
    {
        return $this->CurrenyCode;
    }
    /**
     * Set CurrenyCode value
     * @param string $currenyCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setCurrenyCode($currenyCode = null)
    {
        $this->CurrenyCode = $currenyCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get WaiverCode value
     * @return string|null
     */
    public function getWaiverCode()
    {
        return $this->WaiverCode;
    }
    /**
     * Set WaiverCode value
     * @param string $waiverCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public function setWaiverCode($waiverCode = null)
    {
        $this->WaiverCode = $waiverCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
