<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerInfo Structs
 * @subpackage Structs
 */
class CustomerInfo extends AbstractStructBase
{
    /**
     * The ContactNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\ContactNumbers
     */
    public $ContactNumbers;
    /**
     * The Corporate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Corporate
     */
    public $Corporate;
    /**
     * The CustLoyalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The CustomerIdentifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerIdentifier;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Email[]
     */
    public $Email;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\PersonName[]
     */
    public $PersonName;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Address
     */
    public $Address;
    /**
     * The Passport
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Passport[]
     */
    public $Passport;
    /**
     * The PaymentInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\PaymentInfo
     */
    public $PaymentInfo;
    /**
     * Constructor method for CustomerInfo
     * @uses CustomerInfo::setContactNumbers()
     * @uses CustomerInfo::setCorporate()
     * @uses CustomerInfo::setCustLoyalty()
     * @uses CustomerInfo::setCustomerIdentifier()
     * @uses CustomerInfo::setEmail()
     * @uses CustomerInfo::setPersonName()
     * @uses CustomerInfo::setAddress()
     * @uses CustomerInfo::setPassport()
     * @uses CustomerInfo::setPaymentInfo()
     * @param \Sabre\CreatePassengerNameRecord\Structs\ContactNumbers $contactNumbers
     * @param \Sabre\CreatePassengerNameRecord\Structs\Corporate $corporate
     * @param \Sabre\CreatePassengerNameRecord\Structs\CustLoyalty[] $custLoyalty
     * @param string $customerIdentifier
     * @param \Sabre\CreatePassengerNameRecord\Structs\Email[] $email
     * @param \Sabre\CreatePassengerNameRecord\Structs\PersonName[] $personName
     * @param \Sabre\CreatePassengerNameRecord\Structs\Address $address
     * @param \Sabre\CreatePassengerNameRecord\Structs\Passport[] $passport
     * @param \Sabre\CreatePassengerNameRecord\Structs\PaymentInfo $paymentInfo
     */
    public function __construct(\Sabre\CreatePassengerNameRecord\Structs\ContactNumbers $contactNumbers = null, \Sabre\CreatePassengerNameRecord\Structs\Corporate $corporate = null, array $custLoyalty = array(), $customerIdentifier = null, array $email = array(), array $personName = array(), \Sabre\CreatePassengerNameRecord\Structs\Address $address = null, array $passport = array(), \Sabre\CreatePassengerNameRecord\Structs\PaymentInfo $paymentInfo = null)
    {
        $this
            ->setContactNumbers($contactNumbers)
            ->setCorporate($corporate)
            ->setCustLoyalty($custLoyalty)
            ->setCustomerIdentifier($customerIdentifier)
            ->setEmail($email)
            ->setPersonName($personName)
            ->setAddress($address)
            ->setPassport($passport)
            ->setPaymentInfo($paymentInfo);
    }
    /**
     * Get ContactNumbers value
     * @return \Sabre\CreatePassengerNameRecord\Structs\ContactNumbers|null
     */
    public function getContactNumbers()
    {
        return $this->ContactNumbers;
    }
    /**
     * Set ContactNumbers value
     * @param \Sabre\CreatePassengerNameRecord\Structs\ContactNumbers $contactNumbers
     * @return \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo
     */
    public function setContactNumbers(\Sabre\CreatePassengerNameRecord\Structs\ContactNumbers $contactNumbers = null)
    {
        $this->ContactNumbers = $contactNumbers;
        return $this;
    }
    /**
     * Get Corporate value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Corporate|null
     */
    public function getCorporate()
    {
        return $this->Corporate;
    }
    /**
     * Set Corporate value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Corporate $corporate
     * @return \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo
     */
    public function setCorporate(\Sabre\CreatePassengerNameRecord\Structs\Corporate $corporate = null)
    {
        $this->Corporate = $corporate;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \Sabre\CreatePassengerNameRecord\Structs\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\CustLoyalty[] $custLoyalty
     * @return \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\CustLoyalty $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo
     */
    public function addToCustLoyalty(\Sabre\CreatePassengerNameRecord\Structs\CustLoyalty $item)
    {
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get CustomerIdentifier value
     * @return string|null
     */
    public function getCustomerIdentifier()
    {
        return $this->CustomerIdentifier;
    }
    /**
     * Set CustomerIdentifier value
     * @param string $customerIdentifier
     * @return \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo
     */
    public function setCustomerIdentifier($customerIdentifier = null)
    {
        $this->CustomerIdentifier = $customerIdentifier;
        return $this;
    }
    /**
     * Get Email value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Email[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Email[] $email
     * @return \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo
     */
    public function setEmail(array $email = array())
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Email $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo
     */
    public function addToEmail(\Sabre\CreatePassengerNameRecord\Structs\Email $item)
    {
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName[]|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\PersonName[] $personName
     * @return \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo
     */
    public function setPersonName(array $personName = array())
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Add item to PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\PersonName $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo
     */
    public function addToPersonName(\Sabre\CreatePassengerNameRecord\Structs\PersonName $item)
    {
        $this->PersonName[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Address $address
     * @return \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo
     */
    public function setAddress(\Sabre\CreatePassengerNameRecord\Structs\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Passport value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Passport[]|null
     */
    public function getPassport()
    {
        return $this->Passport;
    }
    /**
     * Set Passport value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Passport[] $passport
     * @return \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo
     */
    public function setPassport(array $passport = array())
    {
        $this->Passport = $passport;
        return $this;
    }
    /**
     * Add item to Passport value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Passport $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo
     */
    public function addToPassport(\Sabre\CreatePassengerNameRecord\Structs\Passport $item)
    {
        $this->Passport[] = $item;
        return $this;
    }
    /**
     * Get PaymentInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\PaymentInfo|null
     */
    public function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    /**
     * Set PaymentInfo value
     * @param \Sabre\CreatePassengerNameRecord\Structs\PaymentInfo $paymentInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo
     */
    public function setPaymentInfo(\Sabre\CreatePassengerNameRecord\Structs\PaymentInfo $paymentInfo = null)
    {
        $this->PaymentInfo = $paymentInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
