<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardHolder Structs
 * @subpackage Structs
 */
class CardHolder extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\PersonNameType
     */
    public $PersonName;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\AddressType
     */
    public $Address;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\PhoneType[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Email;
    /**
     * Constructor method for CardHolder
     * @uses CardHolder::setPersonName()
     * @uses CardHolder::setAddress()
     * @uses CardHolder::setTelephone()
     * @uses CardHolder::setEmail()
     * @param \Sabre\CreatePassengerNameRecord\Structs\PersonNameType $personName
     * @param \Sabre\CreatePassengerNameRecord\Structs\AddressType $address
     * @param \Sabre\CreatePassengerNameRecord\Structs\PhoneType[] $telephone
     * @param string[] $email
     */
    public function __construct(\Sabre\CreatePassengerNameRecord\Structs\PersonNameType $personName = null, \Sabre\CreatePassengerNameRecord\Structs\AddressType $address = null, array $telephone = array(), array $email = array())
    {
        $this
            ->setPersonName($personName)
            ->setAddress($address)
            ->setTelephone($telephone)
            ->setEmail($email);
    }
    /**
     * Get PersonName value
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\CreatePassengerNameRecord\Structs\PersonNameType $personName
     * @return \Sabre\CreatePassengerNameRecord\Structs\CardHolder
     */
    public function setPersonName(\Sabre\CreatePassengerNameRecord\Structs\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Address value
     * @return \Sabre\CreatePassengerNameRecord\Structs\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Sabre\CreatePassengerNameRecord\Structs\AddressType $address
     * @return \Sabre\CreatePassengerNameRecord\Structs\CardHolder
     */
    public function setAddress(\Sabre\CreatePassengerNameRecord\Structs\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \Sabre\CreatePassengerNameRecord\Structs\PhoneType[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\PhoneType[] $telephone
     * @return \Sabre\CreatePassengerNameRecord\Structs\CardHolder
     */
    public function setTelephone(array $telephone = array())
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\PhoneType $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\CardHolder
     */
    public function addToTelephone(\Sabre\CreatePassengerNameRecord\Structs\PhoneType $item)
    {
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return string[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param string[] $email
     * @return \Sabre\CreatePassengerNameRecord\Structs\CardHolder
     */
    public function setEmail(array $email = array())
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\CardHolder
     */
    public function addToEmail($item)
    {
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\CardHolder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
