<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBook Structs
 * @subpackage Structs
 */
class AirBook extends AbstractStructBase
{
    /**
     * The RetryRebook
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\RetryRebook
     */
    public $RetryRebook;
    /**
     * The HaltOnStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\HaltOnStatus[]
     */
    public $HaltOnStatus;
    /**
     * The OriginDestinationInformation
     * @var \Sabre\CreatePassengerNameRecord\Structs\OriginDestinationInformation
     */
    public $OriginDestinationInformation;
    /**
     * The RedisplayReservation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\RedisplayReservation
     */
    public $RedisplayReservation;
    /**
     * The OriginDestinationOption
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\OriginDestinationOption
     */
    public $OriginDestinationOption;
    /**
     * Constructor method for AirBook
     * @uses AirBook::setRetryRebook()
     * @uses AirBook::setHaltOnStatus()
     * @uses AirBook::setOriginDestinationInformation()
     * @uses AirBook::setRedisplayReservation()
     * @uses AirBook::setOriginDestinationOption()
     * @param \Sabre\CreatePassengerNameRecord\Structs\RetryRebook $retryRebook
     * @param \Sabre\CreatePassengerNameRecord\Structs\HaltOnStatus[] $haltOnStatus
     * @param \Sabre\CreatePassengerNameRecord\Structs\OriginDestinationInformation $originDestinationInformation
     * @param \Sabre\CreatePassengerNameRecord\Structs\RedisplayReservation $redisplayReservation
     * @param \Sabre\CreatePassengerNameRecord\Structs\OriginDestinationOption $originDestinationOption
     */
    public function __construct(\Sabre\CreatePassengerNameRecord\Structs\RetryRebook $retryRebook = null, array $haltOnStatus = array(), \Sabre\CreatePassengerNameRecord\Structs\OriginDestinationInformation $originDestinationInformation = null, \Sabre\CreatePassengerNameRecord\Structs\RedisplayReservation $redisplayReservation = null, \Sabre\CreatePassengerNameRecord\Structs\OriginDestinationOption $originDestinationOption = null)
    {
        $this
            ->setRetryRebook($retryRebook)
            ->setHaltOnStatus($haltOnStatus)
            ->setOriginDestinationInformation($originDestinationInformation)
            ->setRedisplayReservation($redisplayReservation)
            ->setOriginDestinationOption($originDestinationOption);
    }
    /**
     * Get RetryRebook value
     * @return \Sabre\CreatePassengerNameRecord\Structs\RetryRebook|null
     */
    public function getRetryRebook()
    {
        return $this->RetryRebook;
    }
    /**
     * Set RetryRebook value
     * @param \Sabre\CreatePassengerNameRecord\Structs\RetryRebook $retryRebook
     * @return \Sabre\CreatePassengerNameRecord\Structs\AirBook
     */
    public function setRetryRebook(\Sabre\CreatePassengerNameRecord\Structs\RetryRebook $retryRebook = null)
    {
        $this->RetryRebook = $retryRebook;
        return $this;
    }
    /**
     * Get HaltOnStatus value
     * @return \Sabre\CreatePassengerNameRecord\Structs\HaltOnStatus[]|null
     */
    public function getHaltOnStatus()
    {
        return $this->HaltOnStatus;
    }
    /**
     * Set HaltOnStatus value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\HaltOnStatus[] $haltOnStatus
     * @return \Sabre\CreatePassengerNameRecord\Structs\AirBook
     */
    public function setHaltOnStatus(array $haltOnStatus = array())
    {
        $this->HaltOnStatus = $haltOnStatus;
        return $this;
    }
    /**
     * Add item to HaltOnStatus value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\HaltOnStatus $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\AirBook
     */
    public function addToHaltOnStatus(\Sabre\CreatePassengerNameRecord\Structs\HaltOnStatus $item)
    {
        $this->HaltOnStatus[] = $item;
        return $this;
    }
    /**
     * Get OriginDestinationInformation value
     * @return \Sabre\CreatePassengerNameRecord\Structs\OriginDestinationInformation|null
     */
    public function getOriginDestinationInformation()
    {
        return $this->OriginDestinationInformation;
    }
    /**
     * Set OriginDestinationInformation value
     * @param \Sabre\CreatePassengerNameRecord\Structs\OriginDestinationInformation $originDestinationInformation
     * @return \Sabre\CreatePassengerNameRecord\Structs\AirBook
     */
    public function setOriginDestinationInformation(\Sabre\CreatePassengerNameRecord\Structs\OriginDestinationInformation $originDestinationInformation = null)
    {
        $this->OriginDestinationInformation = $originDestinationInformation;
        return $this;
    }
    /**
     * Get RedisplayReservation value
     * @return \Sabre\CreatePassengerNameRecord\Structs\RedisplayReservation|null
     */
    public function getRedisplayReservation()
    {
        return $this->RedisplayReservation;
    }
    /**
     * Set RedisplayReservation value
     * @param \Sabre\CreatePassengerNameRecord\Structs\RedisplayReservation $redisplayReservation
     * @return \Sabre\CreatePassengerNameRecord\Structs\AirBook
     */
    public function setRedisplayReservation(\Sabre\CreatePassengerNameRecord\Structs\RedisplayReservation $redisplayReservation = null)
    {
        $this->RedisplayReservation = $redisplayReservation;
        return $this;
    }
    /**
     * Get OriginDestinationOption value
     * @return \Sabre\CreatePassengerNameRecord\Structs\OriginDestinationOption|null
     */
    public function getOriginDestinationOption()
    {
        return $this->OriginDestinationOption;
    }
    /**
     * Set OriginDestinationOption value
     * @param \Sabre\CreatePassengerNameRecord\Structs\OriginDestinationOption $originDestinationOption
     * @return \Sabre\CreatePassengerNameRecord\Structs\AirBook
     */
    public function setOriginDestinationOption(\Sabre\CreatePassengerNameRecord\Structs\OriginDestinationOption $originDestinationOption = null)
    {
        $this->OriginDestinationOption = $originDestinationOption;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\AirBook
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
