<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptablePriceIncrease Structs
 * @subpackage Structs
 */
class AcceptablePriceIncrease extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Determines positive only amount | Determines a type for money amount, exchange rate, or percentage etc. Examples: 100.42, 3.9909, 10.1
     * - minExclusive: 0
     * - fractionDigits: 4
     * @var float
     */
    public $Amount;
    /**
     * The Percent
     * Meta informations extracted from the WSDL
     * - documentation: Determines positive only amount | Determines a type for money amount, exchange rate, or percentage etc. Examples: 100.42, 3.9909, 10.1
     * - minExclusive: 0
     * - fractionDigits: 4
     * @var float
     */
    public $Percent;
    /**
     * The HaltOnNonAcceptablePrice
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $HaltOnNonAcceptablePrice;
    /**
     * Constructor method for AcceptablePriceIncrease
     * @uses AcceptablePriceIncrease::setAmount()
     * @uses AcceptablePriceIncrease::setPercent()
     * @uses AcceptablePriceIncrease::setHaltOnNonAcceptablePrice()
     * @param float $amount
     * @param float $percent
     * @param bool $haltOnNonAcceptablePrice
     */
    public function __construct($amount = null, $percent = null, $haltOnNonAcceptablePrice = false)
    {
        $this
            ->setAmount($amount)
            ->setPercent($percent)
            ->setHaltOnNonAcceptablePrice($haltOnNonAcceptablePrice);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Sabre\CreatePassengerNameRecord\Structs\AcceptablePriceIncrease
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \Sabre\CreatePassengerNameRecord\Structs\AcceptablePriceIncrease
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get HaltOnNonAcceptablePrice value
     * @return bool|null
     */
    public function getHaltOnNonAcceptablePrice()
    {
        return $this->HaltOnNonAcceptablePrice;
    }
    /**
     * Set HaltOnNonAcceptablePrice value
     * @param bool $haltOnNonAcceptablePrice
     * @return \Sabre\CreatePassengerNameRecord\Structs\AcceptablePriceIncrease
     */
    public function setHaltOnNonAcceptablePrice($haltOnNonAcceptablePrice = false)
    {
        $this->HaltOnNonAcceptablePrice = $haltOnNonAcceptablePrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\AcceptablePriceIncrease
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
