<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tour Structs
 * @subpackage Structs
 */
class Tour extends AbstractStructBase
{
    /**
     * The TourDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\TourDetails
     */
    public $TourDetails;
    /**
     * The DayOfWeekInd
     * Meta informations extracted from the WSDL
     * - documentation: "DayOfWeekInd" is used to return the day of the week indicator.
     * - use: optional
     * @var string
     */
    public $DayOfWeekInd;
    /**
     * The DepartureDateTime
     * Meta informations extracted from the WSDL
     * - documentation: "DepartureDateTime" is used to return the date and time associated with the particular tour reservation. | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - use: optional
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The LinkCode
     * Meta informations extracted from the WSDL
     * - documentation: "LinkCode" is used to return the link code
     * - use: optional
     * @var string
     */
    public $LinkCode;
    /**
     * The MergedSegmentInd
     * Meta informations extracted from the WSDL
     * - documentation: "MergedSegmentInd" is used to return the merged segment indicator associated with the particular itinerary segment if applicable.
     * - use: optional
     * @var string
     */
    public $MergedSegmentInd;
    /**
     * The NumberInParty
     * Meta informations extracted from the WSDL
     * - documentation: "NumberInParty" is used to return the number of passengers associated with the particular tour reservation.
     * - use: optional
     * @var string
     */
    public $NumberInParty;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - documentation: "SegmentNumber" is used to return the itinerary segment number.
     * - use: optional
     * @var string
     */
    public $SegmentNumber;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: "Status" is used to return the status code associated with the particular itinerary segment.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The IsPast
     * Meta informations extracted from the WSDL
     * - documentation: It returns information if current segment is past or not. Attribute is populated based on Tour - @DepartureDateTime, Tour - TourDetails - @LocationCode, Tour - TourDetails - Duration - NumDays. There is no end date, but here is
     * duration time, thus end date will be calculated based on start date and duration time. If duration time will not be populated then IsPast attribute will be calculated like for air segment.
     * - use: optional
     * @var bool
     */
    public $IsPast;
    /**
     * Constructor method for Tour
     * @uses Tour::setTourDetails()
     * @uses Tour::setDayOfWeekInd()
     * @uses Tour::setDepartureDateTime()
     * @uses Tour::setLinkCode()
     * @uses Tour::setMergedSegmentInd()
     * @uses Tour::setNumberInParty()
     * @uses Tour::setSegmentNumber()
     * @uses Tour::setStatus()
     * @uses Tour::setType()
     * @uses Tour::setIsPast()
     * @param \Sabre\CreatePassengerNameRecord\Structs\TourDetails $tourDetails
     * @param string $dayOfWeekInd
     * @param string $departureDateTime
     * @param string $linkCode
     * @param string $mergedSegmentInd
     * @param string $numberInParty
     * @param string $segmentNumber
     * @param string $status
     * @param string $type
     * @param bool $isPast
     */
    public function __construct(\Sabre\CreatePassengerNameRecord\Structs\TourDetails $tourDetails = null, $dayOfWeekInd = null, $departureDateTime = null, $linkCode = null, $mergedSegmentInd = null, $numberInParty = null, $segmentNumber = null, $status = null, $type = null, $isPast = null)
    {
        $this
            ->setTourDetails($tourDetails)
            ->setDayOfWeekInd($dayOfWeekInd)
            ->setDepartureDateTime($departureDateTime)
            ->setLinkCode($linkCode)
            ->setMergedSegmentInd($mergedSegmentInd)
            ->setNumberInParty($numberInParty)
            ->setSegmentNumber($segmentNumber)
            ->setStatus($status)
            ->setType($type)
            ->setIsPast($isPast);
    }
    /**
     * Get TourDetails value
     * @return \Sabre\CreatePassengerNameRecord\Structs\TourDetails|null
     */
    public function getTourDetails()
    {
        return $this->TourDetails;
    }
    /**
     * Set TourDetails value
     * @param \Sabre\CreatePassengerNameRecord\Structs\TourDetails $tourDetails
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tour
     */
    public function setTourDetails(\Sabre\CreatePassengerNameRecord\Structs\TourDetails $tourDetails = null)
    {
        $this->TourDetails = $tourDetails;
        return $this;
    }
    /**
     * Get DayOfWeekInd value
     * @return string|null
     */
    public function getDayOfWeekInd()
    {
        return $this->DayOfWeekInd;
    }
    /**
     * Set DayOfWeekInd value
     * @param string $dayOfWeekInd
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tour
     */
    public function setDayOfWeekInd($dayOfWeekInd = null)
    {
        $this->DayOfWeekInd = $dayOfWeekInd;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tour
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get LinkCode value
     * @return string|null
     */
    public function getLinkCode()
    {
        return $this->LinkCode;
    }
    /**
     * Set LinkCode value
     * @param string $linkCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tour
     */
    public function setLinkCode($linkCode = null)
    {
        $this->LinkCode = $linkCode;
        return $this;
    }
    /**
     * Get MergedSegmentInd value
     * @return string|null
     */
    public function getMergedSegmentInd()
    {
        return $this->MergedSegmentInd;
    }
    /**
     * Set MergedSegmentInd value
     * @param string $mergedSegmentInd
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tour
     */
    public function setMergedSegmentInd($mergedSegmentInd = null)
    {
        $this->MergedSegmentInd = $mergedSegmentInd;
        return $this;
    }
    /**
     * Get NumberInParty value
     * @return string|null
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param string $numberInParty
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tour
     */
    public function setNumberInParty($numberInParty = null)
    {
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param string $segmentNumber
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tour
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tour
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tour
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get IsPast value
     * @return bool|null
     */
    public function getIsPast()
    {
        return $this->IsPast;
    }
    /**
     * Set IsPast value
     * @param bool $isPast
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tour
     */
    public function setIsPast($isPast = null)
    {
        $this->IsPast = $isPast;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tour
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
