<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketingFees Structs
 * @subpackage Structs
 */
class TicketingFees extends AbstractStructBase
{
    /**
     * The FeeInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\FeeInformation[]
     */
    public $FeeInformation;
    /**
     * The Disclaimer
     * Meta informations extracted from the WSDL
     * - documentation: "Disclaimer" is used to return ticketing fee disclaimer-related information.
     * - use: optional
     * @var string
     */
    public $Disclaimer;
    /**
     * Constructor method for TicketingFees
     * @uses TicketingFees::setFeeInformation()
     * @uses TicketingFees::setDisclaimer()
     * @param \Sabre\CreatePassengerNameRecord\Structs\FeeInformation[] $feeInformation
     * @param string $disclaimer
     */
    public function __construct(array $feeInformation = array(), $disclaimer = null)
    {
        $this
            ->setFeeInformation($feeInformation)
            ->setDisclaimer($disclaimer);
    }
    /**
     * Get FeeInformation value
     * @return \Sabre\CreatePassengerNameRecord\Structs\FeeInformation[]|null
     */
    public function getFeeInformation()
    {
        return $this->FeeInformation;
    }
    /**
     * Set FeeInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\FeeInformation[] $feeInformation
     * @return \Sabre\CreatePassengerNameRecord\Structs\TicketingFees
     */
    public function setFeeInformation(array $feeInformation = array())
    {
        $this->FeeInformation = $feeInformation;
        return $this;
    }
    /**
     * Add item to FeeInformation value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\FeeInformation $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\TicketingFees
     */
    public function addToFeeInformation(\Sabre\CreatePassengerNameRecord\Structs\FeeInformation $item)
    {
        $this->FeeInformation[] = $item;
        return $this;
    }
    /**
     * Get Disclaimer value
     * @return string|null
     */
    public function getDisclaimer()
    {
        return $this->Disclaimer;
    }
    /**
     * Set Disclaimer value
     * @param string $disclaimer
     * @return \Sabre\CreatePassengerNameRecord\Structs\TicketingFees
     */
    public function setDisclaimer($disclaimer = null)
    {
        $this->Disclaimer = $disclaimer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\TicketingFees
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
