<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing Structs
 * @subpackage Structs
 */
class Ticketing extends AbstractStructBase
{
    /**
     * The TicketType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $TicketType;
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $LocationCode;
    /**
     * The PseudoCityCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The QueueNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $QueueNumber;
    /**
     * The QueueName
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $QueueName;
    /**
     * The ShortText
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ShortText;
    /**
     * The TicketTimeLimit
     * Meta informations extracted from the WSDL
     * - documentation: "TicketTimeLimit" is used to return the ticket time limit-related information. | A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss",
     * "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - use: optional
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $TicketTimeLimit;
    /**
     * The EndNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $EndNumber;
    /**
     * The eTicketNumber
     * Meta informations extracted from the WSDL
     * - documentation: "eTicketNumber" is used to return ticket-related information.
     * - use: optional
     * @var int
     */
    public $eTicketNumber;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Number;
    /**
     * The Coupon
     * Meta informations extracted from the WSDL
     * - maxOccurs: 16
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Coupon[]
     */
    public $Coupon;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public $PersonName;
    /**
     * The ReferenceNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The ConjunctedCount
     * Meta informations extracted from the WSDL
     * - documentation: "ConjunctedCount" is used to return the number of conjuncted eTicket coupons associated with the particular accounting line if applicable.
     * - use: optional
     * @var string
     */
    public $ConjunctedCount;
    /**
     * The CouponCount
     * Meta informations extracted from the WSDL
     * - documentation: "CouponCount" is used to return the number of eTicket coupons associated with the particular accounting line if applicable.
     * - use: optional
     * @var string
     */
    public $CouponCount;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference place holder.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Ticketing
     * @uses Ticketing::setTicketType()
     * @uses Ticketing::setLocationCode()
     * @uses Ticketing::setPseudoCityCode()
     * @uses Ticketing::setQueueNumber()
     * @uses Ticketing::setQueueName()
     * @uses Ticketing::setShortText()
     * @uses Ticketing::setTicketTimeLimit()
     * @uses Ticketing::setEndNumber()
     * @uses Ticketing::setETicketNumber()
     * @uses Ticketing::setNumber()
     * @uses Ticketing::setCoupon()
     * @uses Ticketing::setPersonName()
     * @uses Ticketing::setReferenceNumber()
     * @uses Ticketing::setConjunctedCount()
     * @uses Ticketing::setCouponCount()
     * @uses Ticketing::setRPH()
     * @uses Ticketing::setId()
     * @param string $ticketType
     * @param string $locationCode
     * @param string $pseudoCityCode
     * @param int $queueNumber
     * @param string $queueName
     * @param string $shortText
     * @param string $ticketTimeLimit
     * @param int $endNumber
     * @param int $eTicketNumber
     * @param int $number
     * @param \Sabre\CreatePassengerNameRecord\Structs\Coupon[] $coupon
     * @param \Sabre\CreatePassengerNameRecord\Structs\PersonName $personName
     * @param string $referenceNumber
     * @param string $conjunctedCount
     * @param string $couponCount
     * @param string $rPH
     * @param string $id
     */
    public function __construct($ticketType = null, $locationCode = null, $pseudoCityCode = null, $queueNumber = null, $queueName = null, $shortText = null, $ticketTimeLimit = null, $endNumber = null, $eTicketNumber = null, $number = null, array $coupon = array(), \Sabre\CreatePassengerNameRecord\Structs\PersonName $personName = null, $referenceNumber = null, $conjunctedCount = null, $couponCount = null, $rPH = null, $id = null)
    {
        $this
            ->setTicketType($ticketType)
            ->setLocationCode($locationCode)
            ->setPseudoCityCode($pseudoCityCode)
            ->setQueueNumber($queueNumber)
            ->setQueueName($queueName)
            ->setShortText($shortText)
            ->setTicketTimeLimit($ticketTimeLimit)
            ->setEndNumber($endNumber)
            ->setETicketNumber($eTicketNumber)
            ->setNumber($number)
            ->setCoupon($coupon)
            ->setPersonName($personName)
            ->setReferenceNumber($referenceNumber)
            ->setConjunctedCount($conjunctedCount)
            ->setCouponCount($couponCount)
            ->setRPH($rPH)
            ->setId($id);
    }
    /**
     * Get TicketType value
     * @return string
     */
    public function getTicketType()
    {
        return $this->TicketType;
    }
    /**
     * Set TicketType value
     * @param string $ticketType
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function setTicketType($ticketType = null)
    {
        $this->TicketType = $ticketType;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function setLocationCode($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get QueueNumber value
     * @return int|null
     */
    public function getQueueNumber()
    {
        return $this->QueueNumber;
    }
    /**
     * Set QueueNumber value
     * @param int $queueNumber
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function setQueueNumber($queueNumber = null)
    {
        $this->QueueNumber = $queueNumber;
        return $this;
    }
    /**
     * Get QueueName value
     * @return string|null
     */
    public function getQueueName()
    {
        return $this->QueueName;
    }
    /**
     * Set QueueName value
     * @param string $queueName
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function setQueueName($queueName = null)
    {
        $this->QueueName = $queueName;
        return $this;
    }
    /**
     * Get ShortText value
     * @return string|null
     */
    public function getShortText()
    {
        return $this->ShortText;
    }
    /**
     * Set ShortText value
     * @param string $shortText
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function setShortText($shortText = null)
    {
        $this->ShortText = $shortText;
        return $this;
    }
    /**
     * Get TicketTimeLimit value
     * @return string|null
     */
    public function getTicketTimeLimit()
    {
        return $this->TicketTimeLimit;
    }
    /**
     * Set TicketTimeLimit value
     * @param string $ticketTimeLimit
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function setTicketTimeLimit($ticketTimeLimit = null)
    {
        $this->TicketTimeLimit = $ticketTimeLimit;
        return $this;
    }
    /**
     * Get EndNumber value
     * @return int|null
     */
    public function getEndNumber()
    {
        return $this->EndNumber;
    }
    /**
     * Set EndNumber value
     * @param int $endNumber
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function setEndNumber($endNumber = null)
    {
        $this->EndNumber = $endNumber;
        return $this;
    }
    /**
     * Get eTicketNumber value
     * @return int|null
     */
    public function getETicketNumber()
    {
        return $this->eTicketNumber;
    }
    /**
     * Set eTicketNumber value
     * @param int $eTicketNumber
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function setETicketNumber($eTicketNumber = null)
    {
        $this->eTicketNumber = $eTicketNumber;
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Coupon value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Coupon[]|null
     */
    public function getCoupon()
    {
        return $this->Coupon;
    }
    /**
     * Set Coupon value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Coupon[] $coupon
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function setCoupon(array $coupon = array())
    {
        $this->Coupon = $coupon;
        return $this;
    }
    /**
     * Add item to Coupon value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Coupon $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function addToCoupon(\Sabre\CreatePassengerNameRecord\Structs\Coupon $item)
    {
        $this->Coupon[] = $item;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\CreatePassengerNameRecord\Structs\PersonName $personName
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function setPersonName(\Sabre\CreatePassengerNameRecord\Structs\PersonName $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get ConjunctedCount value
     * @return string|null
     */
    public function getConjunctedCount()
    {
        return $this->ConjunctedCount;
    }
    /**
     * Set ConjunctedCount value
     * @param string $conjunctedCount
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function setConjunctedCount($conjunctedCount = null)
    {
        $this->ConjunctedCount = $conjunctedCount;
        return $this;
    }
    /**
     * Get CouponCount value
     * @return string|null
     */
    public function getCouponCount()
    {
        return $this->CouponCount;
    }
    /**
     * Set CouponCount value
     * @param string $couponCount
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function setCouponCount($couponCount = null)
    {
        $this->CouponCount = $couponCount;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
