<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerType Structs
 * @subpackage Structs
 */
class PassengerType extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Force
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Force;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Quantity;
    /**
     * The Age
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Age;
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var float
     */
    public $Total;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\PersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\PhoneType[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var string[]
     */
    public $Email;
    /**
     * The passengerID
     * @var string
     */
    public $passengerID;
    /**
     * The primary
     * @var bool
     */
    public $primary;
    /**
     * Constructor method for PassengerType
     * @uses PassengerType::setCode()
     * @uses PassengerType::setForce()
     * @uses PassengerType::setQuantity()
     * @uses PassengerType::setAge()
     * @uses PassengerType::setTotal()
     * @uses PassengerType::setType()
     * @uses PassengerType::setPersonName()
     * @uses PassengerType::setTelephone()
     * @uses PassengerType::setEmail()
     * @uses PassengerType::setPassengerID()
     * @uses PassengerType::setPrimary()
     * @param string $code
     * @param bool $force
     * @param string $quantity
     * @param int $age
     * @param float $total
     * @param string $type
     * @param \Sabre\CreatePassengerNameRecord\Structs\PersonNameType $personName
     * @param \Sabre\CreatePassengerNameRecord\Structs\PhoneType[] $telephone
     * @param string[] $email
     * @param string $passengerID
     * @param bool $primary
     */
    public function __construct($code = null, $force = null, $quantity = null, $age = null, $total = null, $type = null, \Sabre\CreatePassengerNameRecord\Structs\PersonNameType $personName = null, array $telephone = array(), array $email = array(), $passengerID = null, $primary = null)
    {
        $this
            ->setCode($code)
            ->setForce($force)
            ->setQuantity($quantity)
            ->setAge($age)
            ->setTotal($total)
            ->setType($type)
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setPassengerID($passengerID)
            ->setPrimary($primary);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\CreatePassengerNameRecord\Structs\PassengerType
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Force value
     * @return bool|null
     */
    public function getForce()
    {
        return $this->Force;
    }
    /**
     * Set Force value
     * @param bool $force
     * @return \Sabre\CreatePassengerNameRecord\Structs\PassengerType
     */
    public function setForce($force = null)
    {
        $this->Force = $force;
        return $this;
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \Sabre\CreatePassengerNameRecord\Structs\PassengerType
     */
    public function setQuantity($quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \Sabre\CreatePassengerNameRecord\Structs\PassengerType
     */
    public function setAge($age = null)
    {
        $this->Age = $age;
        return $this;
    }
    /**
     * Get Total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param float $total
     * @return \Sabre\CreatePassengerNameRecord\Structs\PassengerType
     */
    public function setTotal($total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Sabre\CreatePassengerNameRecord\Enums\Type::valueIsValid()
     * @uses \Sabre\CreatePassengerNameRecord\Enums\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Sabre\CreatePassengerNameRecord\Structs\PassengerType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\CreatePassengerNameRecord\Structs\PersonNameType $personName
     * @return \Sabre\CreatePassengerNameRecord\Structs\PassengerType
     */
    public function setPersonName(\Sabre\CreatePassengerNameRecord\Structs\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \Sabre\CreatePassengerNameRecord\Structs\PhoneType[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\PhoneType[] $telephone
     * @return \Sabre\CreatePassengerNameRecord\Structs\PassengerType
     */
    public function setTelephone(array $telephone = array())
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\PhoneType $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\PassengerType
     */
    public function addToTelephone(\Sabre\CreatePassengerNameRecord\Structs\PhoneType $item)
    {
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return string[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param string[] $email
     * @return \Sabre\CreatePassengerNameRecord\Structs\PassengerType
     */
    public function setEmail(array $email = array())
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\PassengerType
     */
    public function addToEmail($item)
    {
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get passengerID value
     * @return string|null
     */
    public function getPassengerID()
    {
        return $this->passengerID;
    }
    /**
     * Set passengerID value
     * @param string $passengerID
     * @return \Sabre\CreatePassengerNameRecord\Structs\PassengerType
     */
    public function setPassengerID($passengerID = null)
    {
        $this->passengerID = $passengerID;
        return $this;
    }
    /**
     * Get primary value
     * @return bool|null
     */
    public function getPrimary()
    {
        return $this->primary;
    }
    /**
     * Set primary value
     * @param bool $primary
     * @return \Sabre\CreatePassengerNameRecord\Structs\PassengerType
     */
    public function setPrimary($primary = null)
    {
        $this->primary = $primary;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\PassengerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
