<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperatingAirline Structs
 * @subpackage Structs
 */
class OperatingAirline extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: "Code" is used to return the operating airline code associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The CompanyShortName
     * Meta informations extracted from the WSDL
     * - documentation: "CompanyShortName" is used to return the operating airline name.
     * - use: optional
     * @var string
     */
    public $CompanyShortName;
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - documentation: "FlightNumber" is used to return the flight number associated with the operating airline's flight segment.
     * - use: optional
     * @var string
     */
    public $FlightNumber;
    /**
     * Constructor method for OperatingAirline
     * @uses OperatingAirline::setCode()
     * @uses OperatingAirline::setCompanyShortName()
     * @uses OperatingAirline::setFlightNumber()
     * @param string $code
     * @param string $companyShortName
     * @param string $flightNumber
     */
    public function __construct($code = null, $companyShortName = null, $flightNumber = null)
    {
        $this
            ->setCode($code)
            ->setCompanyShortName($companyShortName)
            ->setFlightNumber($flightNumber);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\CreatePassengerNameRecord\Structs\OperatingAirline
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CompanyShortName value
     * @return string|null
     */
    public function getCompanyShortName()
    {
        return $this->CompanyShortName;
    }
    /**
     * Set CompanyShortName value
     * @param string $companyShortName
     * @return \Sabre\CreatePassengerNameRecord\Structs\OperatingAirline
     */
    public function setCompanyShortName($companyShortName = null)
    {
        $this->CompanyShortName = $companyShortName;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \Sabre\CreatePassengerNameRecord\Structs\OperatingAirline
     */
    public function setFlightNumber($flightNumber = null)
    {
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\OperatingAirline
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
