<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItineraryInfo Structs
 * @subpackage Structs
 */
class ItineraryInfo extends AbstractStructBase
{
    /**
     * The ReservationItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\ReservationItems
     */
    public $ReservationItems;
    /**
     * The FlightSegment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\FlightSegment[]
     */
    public $FlightSegment;
    /**
     * The BookingMethodReq
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BookingMethodReq;
    /**
     * The SegmentCount
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SegmentCount;
    /**
     * The PTC_FareBreakdown
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\PTC_FareBreakdown
     */
    public $PTC_FareBreakdown;
    /**
     * The TaxInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\TaxInfo
     */
    public $TaxInfo;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $RPH;
    /**
     * The ItineraryPricing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\ItineraryPricing
     */
    public $ItineraryPricing;
    /**
     * The Ticketing
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Ticketing[]
     */
    public $Ticketing;
    /**
     * Constructor method for ItineraryInfo
     * @uses ItineraryInfo::setReservationItems()
     * @uses ItineraryInfo::setFlightSegment()
     * @uses ItineraryInfo::setBookingMethodReq()
     * @uses ItineraryInfo::setSegmentCount()
     * @uses ItineraryInfo::setPTC_FareBreakdown()
     * @uses ItineraryInfo::setTaxInfo()
     * @uses ItineraryInfo::setRPH()
     * @uses ItineraryInfo::setItineraryPricing()
     * @uses ItineraryInfo::setTicketing()
     * @param \Sabre\CreatePassengerNameRecord\Structs\ReservationItems $reservationItems
     * @param \Sabre\CreatePassengerNameRecord\Structs\FlightSegment[] $flightSegment
     * @param string $bookingMethodReq
     * @param string $segmentCount
     * @param \Sabre\CreatePassengerNameRecord\Structs\PTC_FareBreakdown $pTC_FareBreakdown
     * @param \Sabre\CreatePassengerNameRecord\Structs\TaxInfo $taxInfo
     * @param int $rPH
     * @param \Sabre\CreatePassengerNameRecord\Structs\ItineraryPricing $itineraryPricing
     * @param \Sabre\CreatePassengerNameRecord\Structs\Ticketing[] $ticketing
     */
    public function __construct(\Sabre\CreatePassengerNameRecord\Structs\ReservationItems $reservationItems = null, array $flightSegment = array(), $bookingMethodReq = null, $segmentCount = null, \Sabre\CreatePassengerNameRecord\Structs\PTC_FareBreakdown $pTC_FareBreakdown = null, \Sabre\CreatePassengerNameRecord\Structs\TaxInfo $taxInfo = null, $rPH = null, \Sabre\CreatePassengerNameRecord\Structs\ItineraryPricing $itineraryPricing = null, array $ticketing = array())
    {
        $this
            ->setReservationItems($reservationItems)
            ->setFlightSegment($flightSegment)
            ->setBookingMethodReq($bookingMethodReq)
            ->setSegmentCount($segmentCount)
            ->setPTC_FareBreakdown($pTC_FareBreakdown)
            ->setTaxInfo($taxInfo)
            ->setRPH($rPH)
            ->setItineraryPricing($itineraryPricing)
            ->setTicketing($ticketing);
    }
    /**
     * Get ReservationItems value
     * @return \Sabre\CreatePassengerNameRecord\Structs\ReservationItems|null
     */
    public function getReservationItems()
    {
        return $this->ReservationItems;
    }
    /**
     * Set ReservationItems value
     * @param \Sabre\CreatePassengerNameRecord\Structs\ReservationItems $reservationItems
     * @return \Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo
     */
    public function setReservationItems(\Sabre\CreatePassengerNameRecord\Structs\ReservationItems $reservationItems = null)
    {
        $this->ReservationItems = $reservationItems;
        return $this;
    }
    /**
     * Get FlightSegment value
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment[]|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\FlightSegment[] $flightSegment
     * @return \Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo
     */
    public function setFlightSegment(array $flightSegment = array())
    {
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Add item to FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\FlightSegment $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo
     */
    public function addToFlightSegment(\Sabre\CreatePassengerNameRecord\Structs\FlightSegment $item)
    {
        $this->FlightSegment[] = $item;
        return $this;
    }
    /**
     * Get BookingMethodReq value
     * @return string|null
     */
    public function getBookingMethodReq()
    {
        return $this->BookingMethodReq;
    }
    /**
     * Set BookingMethodReq value
     * @param string $bookingMethodReq
     * @return \Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo
     */
    public function setBookingMethodReq($bookingMethodReq = null)
    {
        $this->BookingMethodReq = $bookingMethodReq;
        return $this;
    }
    /**
     * Get SegmentCount value
     * @return string|null
     */
    public function getSegmentCount()
    {
        return $this->SegmentCount;
    }
    /**
     * Set SegmentCount value
     * @param string $segmentCount
     * @return \Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo
     */
    public function setSegmentCount($segmentCount = null)
    {
        $this->SegmentCount = $segmentCount;
        return $this;
    }
    /**
     * Get PTC_FareBreakdown value
     * @return \Sabre\CreatePassengerNameRecord\Structs\PTC_FareBreakdown|null
     */
    public function getPTC_FareBreakdown()
    {
        return $this->PTC_FareBreakdown;
    }
    /**
     * Set PTC_FareBreakdown value
     * @param \Sabre\CreatePassengerNameRecord\Structs\PTC_FareBreakdown $pTC_FareBreakdown
     * @return \Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo
     */
    public function setPTC_FareBreakdown(\Sabre\CreatePassengerNameRecord\Structs\PTC_FareBreakdown $pTC_FareBreakdown = null)
    {
        $this->PTC_FareBreakdown = $pTC_FareBreakdown;
        return $this;
    }
    /**
     * Get TaxInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\TaxInfo|null
     */
    public function getTaxInfo()
    {
        return $this->TaxInfo;
    }
    /**
     * Set TaxInfo value
     * @param \Sabre\CreatePassengerNameRecord\Structs\TaxInfo $taxInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo
     */
    public function setTaxInfo(\Sabre\CreatePassengerNameRecord\Structs\TaxInfo $taxInfo = null)
    {
        $this->TaxInfo = $taxInfo;
        return $this;
    }
    /**
     * Get RPH value
     * @return int|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param int $rPH
     * @return \Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get ItineraryPricing value
     * @return \Sabre\CreatePassengerNameRecord\Structs\ItineraryPricing|null
     */
    public function getItineraryPricing()
    {
        return $this->ItineraryPricing;
    }
    /**
     * Set ItineraryPricing value
     * @param \Sabre\CreatePassengerNameRecord\Structs\ItineraryPricing $itineraryPricing
     * @return \Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo
     */
    public function setItineraryPricing(\Sabre\CreatePassengerNameRecord\Structs\ItineraryPricing $itineraryPricing = null)
    {
        $this->ItineraryPricing = $itineraryPricing;
        return $this;
    }
    /**
     * Get Ticketing value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ticketing[]|null
     */
    public function getTicketing()
    {
        return $this->Ticketing;
    }
    /**
     * Set Ticketing value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Ticketing[] $ticketing
     * @return \Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo
     */
    public function setTicketing(array $ticketing = array())
    {
        $this->Ticketing = $ticketing;
        return $this;
    }
    /**
     * Add item to Ticketing value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Ticketing $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo
     */
    public function addToTicketing(\Sabre\CreatePassengerNameRecord\Structs\Ticketing $item)
    {
        $this->Ticketing[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
