<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FutureQueuePlaceRemark Structs
 * @subpackage Structs
 */
class FutureQueuePlaceRemark extends AbstractStructBase
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $Date;
    /**
     * The PrefatoryInstructionCode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PrefatoryInstructionCode;
    /**
     * The QueueIdentifier
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $QueueIdentifier;
    /**
     * The PseudoCityCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The Time
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: A simple time type. Seconds can be omitted, since those values are not propagated to the Sabre backend systems. Accepted formats: "hh:mm:ss" or "hh:mm"
     * - pattern: ([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $Time;
    /**
     * Constructor method for FutureQueuePlaceRemark
     * @uses FutureQueuePlaceRemark::setDate()
     * @uses FutureQueuePlaceRemark::setPrefatoryInstructionCode()
     * @uses FutureQueuePlaceRemark::setQueueIdentifier()
     * @uses FutureQueuePlaceRemark::setPseudoCityCode()
     * @uses FutureQueuePlaceRemark::setTime()
     * @param string $date
     * @param string $prefatoryInstructionCode
     * @param string $queueIdentifier
     * @param string $pseudoCityCode
     * @param string $time
     */
    public function __construct($date = null, $prefatoryInstructionCode = null, $queueIdentifier = null, $pseudoCityCode = null, $time = null)
    {
        $this
            ->setDate($date)
            ->setPrefatoryInstructionCode($prefatoryInstructionCode)
            ->setQueueIdentifier($queueIdentifier)
            ->setPseudoCityCode($pseudoCityCode)
            ->setTime($time);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \Sabre\CreatePassengerNameRecord\Structs\FutureQueuePlaceRemark
     */
    public function setDate($date = null)
    {
        $this->Date = $date;
        return $this;
    }
    /**
     * Get PrefatoryInstructionCode value
     * @return string
     */
    public function getPrefatoryInstructionCode()
    {
        return $this->PrefatoryInstructionCode;
    }
    /**
     * Set PrefatoryInstructionCode value
     * @param string $prefatoryInstructionCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\FutureQueuePlaceRemark
     */
    public function setPrefatoryInstructionCode($prefatoryInstructionCode = null)
    {
        $this->PrefatoryInstructionCode = $prefatoryInstructionCode;
        return $this;
    }
    /**
     * Get QueueIdentifier value
     * @return string
     */
    public function getQueueIdentifier()
    {
        return $this->QueueIdentifier;
    }
    /**
     * Set QueueIdentifier value
     * @param string $queueIdentifier
     * @return \Sabre\CreatePassengerNameRecord\Structs\FutureQueuePlaceRemark
     */
    public function setQueueIdentifier($queueIdentifier = null)
    {
        $this->QueueIdentifier = $queueIdentifier;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\FutureQueuePlaceRemark
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get Time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param string $time
     * @return \Sabre\CreatePassengerNameRecord\Structs\FutureQueuePlaceRemark
     */
    public function setTime($time = null)
    {
        $this->Time = $time;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\FutureQueuePlaceRemark
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
