<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BrandedFareInformation Structs
 * @subpackage Structs
 */
class BrandedFareInformation extends AbstractStructBase
{
    /**
     * The BrandCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BrandCode;
    /**
     * The BrandName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BrandName;
    /**
     * The ProgramCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProgramCode;
    /**
     * The ProgramName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProgramName;
    /**
     * Constructor method for BrandedFareInformation
     * @uses BrandedFareInformation::setBrandCode()
     * @uses BrandedFareInformation::setBrandName()
     * @uses BrandedFareInformation::setProgramCode()
     * @uses BrandedFareInformation::setProgramName()
     * @param string $brandCode
     * @param string $brandName
     * @param string $programCode
     * @param string $programName
     */
    public function __construct($brandCode = null, $brandName = null, $programCode = null, $programName = null)
    {
        $this
            ->setBrandCode($brandCode)
            ->setBrandName($brandName)
            ->setProgramCode($programCode)
            ->setProgramName($programName);
    }
    /**
     * Get BrandCode value
     * @return string|null
     */
    public function getBrandCode()
    {
        return $this->BrandCode;
    }
    /**
     * Set BrandCode value
     * @param string $brandCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\BrandedFareInformation
     */
    public function setBrandCode($brandCode = null)
    {
        $this->BrandCode = $brandCode;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \Sabre\CreatePassengerNameRecord\Structs\BrandedFareInformation
     */
    public function setBrandName($brandName = null)
    {
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get ProgramCode value
     * @return string|null
     */
    public function getProgramCode()
    {
        return $this->ProgramCode;
    }
    /**
     * Set ProgramCode value
     * @param string $programCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\BrandedFareInformation
     */
    public function setProgramCode($programCode = null)
    {
        $this->ProgramCode = $programCode;
        return $this;
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \Sabre\CreatePassengerNameRecord\Structs\BrandedFareInformation
     */
    public function setProgramName($programName = null)
    {
        $this->ProgramName = $programName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\BrandedFareInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
