<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelItinerary Structs
 * @subpackage Structs
 */
class TravelItinerary extends AbstractStructBase
{
    /**
     * The AccountingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\AccountingInfo[]
     */
    public $AccountingInfo;
    /**
     * The CustomerInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo
     */
    public $CustomerInfo;
    /**
     * The FileInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\FileInfo
     */
    public $FileInfo;
    /**
     * The ItineraryInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo
     */
    public $ItineraryInfo;
    /**
     * The ItineraryRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\ItineraryRef
     */
    public $ItineraryRef;
    /**
     * The PayInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\PayInfo[]
     */
    public $PayInfo;
    /**
     * The QueueInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\QueueInfo
     */
    public $QueueInfo;
    /**
     * The RemarkInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\RemarkInfo
     */
    public $RemarkInfo;
    /**
     * The SpecialServiceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\SpecialServiceInfo[]
     */
    public $SpecialServiceInfo;
    /**
     * The OpenReservationElements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\OpenReservationElements
     */
    public $OpenReservationElements;
    /**
     * The CorporateIDInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\CorporateIDInfo[]
     */
    public $CorporateIDInfo;
    /**
     * Constructor method for TravelItinerary
     * @uses TravelItinerary::setAccountingInfo()
     * @uses TravelItinerary::setCustomerInfo()
     * @uses TravelItinerary::setFileInfo()
     * @uses TravelItinerary::setItineraryInfo()
     * @uses TravelItinerary::setItineraryRef()
     * @uses TravelItinerary::setPayInfo()
     * @uses TravelItinerary::setQueueInfo()
     * @uses TravelItinerary::setRemarkInfo()
     * @uses TravelItinerary::setSpecialServiceInfo()
     * @uses TravelItinerary::setOpenReservationElements()
     * @uses TravelItinerary::setCorporateIDInfo()
     * @param \Sabre\CreatePassengerNameRecord\Structs\AccountingInfo[] $accountingInfo
     * @param \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo $customerInfo
     * @param \Sabre\CreatePassengerNameRecord\Structs\FileInfo $fileInfo
     * @param \Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo $itineraryInfo
     * @param \Sabre\CreatePassengerNameRecord\Structs\ItineraryRef $itineraryRef
     * @param \Sabre\CreatePassengerNameRecord\Structs\PayInfo[] $payInfo
     * @param \Sabre\CreatePassengerNameRecord\Structs\QueueInfo $queueInfo
     * @param \Sabre\CreatePassengerNameRecord\Structs\RemarkInfo $remarkInfo
     * @param \Sabre\CreatePassengerNameRecord\Structs\SpecialServiceInfo[] $specialServiceInfo
     * @param \Sabre\CreatePassengerNameRecord\Structs\OpenReservationElements $openReservationElements
     * @param \Sabre\CreatePassengerNameRecord\Structs\CorporateIDInfo[] $corporateIDInfo
     */
    public function __construct(array $accountingInfo = array(), \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo $customerInfo = null, \Sabre\CreatePassengerNameRecord\Structs\FileInfo $fileInfo = null, \Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo $itineraryInfo = null, \Sabre\CreatePassengerNameRecord\Structs\ItineraryRef $itineraryRef = null, array $payInfo = array(), \Sabre\CreatePassengerNameRecord\Structs\QueueInfo $queueInfo = null, \Sabre\CreatePassengerNameRecord\Structs\RemarkInfo $remarkInfo = null, array $specialServiceInfo = array(), \Sabre\CreatePassengerNameRecord\Structs\OpenReservationElements $openReservationElements = null, array $corporateIDInfo = array())
    {
        $this
            ->setAccountingInfo($accountingInfo)
            ->setCustomerInfo($customerInfo)
            ->setFileInfo($fileInfo)
            ->setItineraryInfo($itineraryInfo)
            ->setItineraryRef($itineraryRef)
            ->setPayInfo($payInfo)
            ->setQueueInfo($queueInfo)
            ->setRemarkInfo($remarkInfo)
            ->setSpecialServiceInfo($specialServiceInfo)
            ->setOpenReservationElements($openReservationElements)
            ->setCorporateIDInfo($corporateIDInfo);
    }
    /**
     * Get AccountingInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\AccountingInfo[]|null
     */
    public function getAccountingInfo()
    {
        return $this->AccountingInfo;
    }
    /**
     * Set AccountingInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\AccountingInfo[] $accountingInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\TravelItinerary
     */
    public function setAccountingInfo(array $accountingInfo = array())
    {
        $this->AccountingInfo = $accountingInfo;
        return $this;
    }
    /**
     * Add item to AccountingInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\AccountingInfo $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\TravelItinerary
     */
    public function addToAccountingInfo(\Sabre\CreatePassengerNameRecord\Structs\AccountingInfo $item)
    {
        $this->AccountingInfo[] = $item;
        return $this;
    }
    /**
     * Get CustomerInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo|null
     */
    public function getCustomerInfo()
    {
        return $this->CustomerInfo;
    }
    /**
     * Set CustomerInfo value
     * @param \Sabre\CreatePassengerNameRecord\Structs\CustomerInfo $customerInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\TravelItinerary
     */
    public function setCustomerInfo(\Sabre\CreatePassengerNameRecord\Structs\CustomerInfo $customerInfo = null)
    {
        $this->CustomerInfo = $customerInfo;
        return $this;
    }
    /**
     * Get FileInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\FileInfo|null
     */
    public function getFileInfo()
    {
        return $this->FileInfo;
    }
    /**
     * Set FileInfo value
     * @param \Sabre\CreatePassengerNameRecord\Structs\FileInfo $fileInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\TravelItinerary
     */
    public function setFileInfo(\Sabre\CreatePassengerNameRecord\Structs\FileInfo $fileInfo = null)
    {
        $this->FileInfo = $fileInfo;
        return $this;
    }
    /**
     * Get ItineraryInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo|null
     */
    public function getItineraryInfo()
    {
        return $this->ItineraryInfo;
    }
    /**
     * Set ItineraryInfo value
     * @param \Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo $itineraryInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\TravelItinerary
     */
    public function setItineraryInfo(\Sabre\CreatePassengerNameRecord\Structs\ItineraryInfo $itineraryInfo = null)
    {
        $this->ItineraryInfo = $itineraryInfo;
        return $this;
    }
    /**
     * Get ItineraryRef value
     * @return \Sabre\CreatePassengerNameRecord\Structs\ItineraryRef|null
     */
    public function getItineraryRef()
    {
        return $this->ItineraryRef;
    }
    /**
     * Set ItineraryRef value
     * @param \Sabre\CreatePassengerNameRecord\Structs\ItineraryRef $itineraryRef
     * @return \Sabre\CreatePassengerNameRecord\Structs\TravelItinerary
     */
    public function setItineraryRef(\Sabre\CreatePassengerNameRecord\Structs\ItineraryRef $itineraryRef = null)
    {
        $this->ItineraryRef = $itineraryRef;
        return $this;
    }
    /**
     * Get PayInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\PayInfo[]|null
     */
    public function getPayInfo()
    {
        return $this->PayInfo;
    }
    /**
     * Set PayInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\PayInfo[] $payInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\TravelItinerary
     */
    public function setPayInfo(array $payInfo = array())
    {
        $this->PayInfo = $payInfo;
        return $this;
    }
    /**
     * Add item to PayInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\PayInfo $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\TravelItinerary
     */
    public function addToPayInfo(\Sabre\CreatePassengerNameRecord\Structs\PayInfo $item)
    {
        $this->PayInfo[] = $item;
        return $this;
    }
    /**
     * Get QueueInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\QueueInfo|null
     */
    public function getQueueInfo()
    {
        return $this->QueueInfo;
    }
    /**
     * Set QueueInfo value
     * @param \Sabre\CreatePassengerNameRecord\Structs\QueueInfo $queueInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\TravelItinerary
     */
    public function setQueueInfo(\Sabre\CreatePassengerNameRecord\Structs\QueueInfo $queueInfo = null)
    {
        $this->QueueInfo = $queueInfo;
        return $this;
    }
    /**
     * Get RemarkInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\RemarkInfo|null
     */
    public function getRemarkInfo()
    {
        return $this->RemarkInfo;
    }
    /**
     * Set RemarkInfo value
     * @param \Sabre\CreatePassengerNameRecord\Structs\RemarkInfo $remarkInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\TravelItinerary
     */
    public function setRemarkInfo(\Sabre\CreatePassengerNameRecord\Structs\RemarkInfo $remarkInfo = null)
    {
        $this->RemarkInfo = $remarkInfo;
        return $this;
    }
    /**
     * Get SpecialServiceInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\SpecialServiceInfo[]|null
     */
    public function getSpecialServiceInfo()
    {
        return $this->SpecialServiceInfo;
    }
    /**
     * Set SpecialServiceInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\SpecialServiceInfo[] $specialServiceInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\TravelItinerary
     */
    public function setSpecialServiceInfo(array $specialServiceInfo = array())
    {
        $this->SpecialServiceInfo = $specialServiceInfo;
        return $this;
    }
    /**
     * Add item to SpecialServiceInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\SpecialServiceInfo $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\TravelItinerary
     */
    public function addToSpecialServiceInfo(\Sabre\CreatePassengerNameRecord\Structs\SpecialServiceInfo $item)
    {
        $this->SpecialServiceInfo[] = $item;
        return $this;
    }
    /**
     * Get OpenReservationElements value
     * @return \Sabre\CreatePassengerNameRecord\Structs\OpenReservationElements|null
     */
    public function getOpenReservationElements()
    {
        return $this->OpenReservationElements;
    }
    /**
     * Set OpenReservationElements value
     * @param \Sabre\CreatePassengerNameRecord\Structs\OpenReservationElements $openReservationElements
     * @return \Sabre\CreatePassengerNameRecord\Structs\TravelItinerary
     */
    public function setOpenReservationElements(\Sabre\CreatePassengerNameRecord\Structs\OpenReservationElements $openReservationElements = null)
    {
        $this->OpenReservationElements = $openReservationElements;
        return $this;
    }
    /**
     * Get CorporateIDInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\CorporateIDInfo[]|null
     */
    public function getCorporateIDInfo()
    {
        return $this->CorporateIDInfo;
    }
    /**
     * Set CorporateIDInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\CorporateIDInfo[] $corporateIDInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\TravelItinerary
     */
    public function setCorporateIDInfo(array $corporateIDInfo = array())
    {
        $this->CorporateIDInfo = $corporateIDInfo;
        return $this;
    }
    /**
     * Add item to CorporateIDInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\CorporateIDInfo $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\TravelItinerary
     */
    public function addToCorporateIDInfo(\Sabre\CreatePassengerNameRecord\Structs\CorporateIDInfo $item)
    {
        $this->CorporateIDInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\TravelItinerary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
