<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemarkInfo Structs
 * Meta informations extracted from the WSDL
 * - documentation: "RemarkInfo" holds details of Remarks
 * @subpackage Structs
 */
class RemarkInfo extends AbstractStructBase
{
    /**
     * The FOP_Remark
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\FOP_Remark
     */
    public $FOP_Remark;
    /**
     * The FutureQueuePlaceRemark
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\FutureQueuePlaceRemark
     */
    public $FutureQueuePlaceRemark;
    /**
     * The Remark
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Remark[]
     */
    public $Remark;
    /**
     * Constructor method for RemarkInfo
     * @uses RemarkInfo::setFOP_Remark()
     * @uses RemarkInfo::setFutureQueuePlaceRemark()
     * @uses RemarkInfo::setRemark()
     * @param \Sabre\CreatePassengerNameRecord\Structs\FOP_Remark $fOP_Remark
     * @param \Sabre\CreatePassengerNameRecord\Structs\FutureQueuePlaceRemark $futureQueuePlaceRemark
     * @param \Sabre\CreatePassengerNameRecord\Structs\Remark[] $remark
     */
    public function __construct(\Sabre\CreatePassengerNameRecord\Structs\FOP_Remark $fOP_Remark = null, \Sabre\CreatePassengerNameRecord\Structs\FutureQueuePlaceRemark $futureQueuePlaceRemark = null, array $remark = array())
    {
        $this
            ->setFOP_Remark($fOP_Remark)
            ->setFutureQueuePlaceRemark($futureQueuePlaceRemark)
            ->setRemark($remark);
    }
    /**
     * Get FOP_Remark value
     * @return \Sabre\CreatePassengerNameRecord\Structs\FOP_Remark|null
     */
    public function getFOP_Remark()
    {
        return $this->FOP_Remark;
    }
    /**
     * Set FOP_Remark value
     * @param \Sabre\CreatePassengerNameRecord\Structs\FOP_Remark $fOP_Remark
     * @return \Sabre\CreatePassengerNameRecord\Structs\RemarkInfo
     */
    public function setFOP_Remark(\Sabre\CreatePassengerNameRecord\Structs\FOP_Remark $fOP_Remark = null)
    {
        $this->FOP_Remark = $fOP_Remark;
        return $this;
    }
    /**
     * Get FutureQueuePlaceRemark value
     * @return \Sabre\CreatePassengerNameRecord\Structs\FutureQueuePlaceRemark|null
     */
    public function getFutureQueuePlaceRemark()
    {
        return $this->FutureQueuePlaceRemark;
    }
    /**
     * Set FutureQueuePlaceRemark value
     * @param \Sabre\CreatePassengerNameRecord\Structs\FutureQueuePlaceRemark $futureQueuePlaceRemark
     * @return \Sabre\CreatePassengerNameRecord\Structs\RemarkInfo
     */
    public function setFutureQueuePlaceRemark(\Sabre\CreatePassengerNameRecord\Structs\FutureQueuePlaceRemark $futureQueuePlaceRemark = null)
    {
        $this->FutureQueuePlaceRemark = $futureQueuePlaceRemark;
        return $this;
    }
    /**
     * Get Remark value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Remark[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Remark[] $remark
     * @return \Sabre\CreatePassengerNameRecord\Structs\RemarkInfo
     */
    public function setRemark(array $remark = array())
    {
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Remark $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\RemarkInfo
     */
    public function addToRemark(\Sabre\CreatePassengerNameRecord\Structs\Remark $item)
    {
        $this->Remark[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\RemarkInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
