<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailType Structs
 * @subpackage Structs
 */
class RailType extends AbstractStructBase
{
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The Open
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Open;
    /**
     * The CrossBorder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CrossBorder;
    /**
     * The Duration
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Duration;
    /**
     * The MarketingCarrier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\MarketingCarrier
     */
    public $MarketingCarrier;
    /**
     * The OperatingCarrier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\ServiceProviderType
     */
    public $OperatingCarrier;
    /**
     * The Passengers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Passengers
     */
    public $Passengers;
    /**
     * The SupplementaryServices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\SupplementaryServices
     */
    public $SupplementaryServices;
    /**
     * The TrainInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\TrainDetailsType
     */
    public $TrainInfo;
    /**
     * The Accommodation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\RailAccommodationType[]
     */
    public $Accommodation;
    /**
     * The StartDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType
     */
    public $StartDetails;
    /**
     * The StopDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType[]
     */
    public $StopDetails;
    /**
     * The EndDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType
     */
    public $EndDetails;
    /**
     * The RailFares
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\RailFareType
     */
    public $RailFares;
    /**
     * The Documents
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Documents
     */
    public $Documents;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Details
     */
    public $Details;
    /**
     * Constructor method for RailType
     * @uses RailType::setStatusCode()
     * @uses RailType::setOpen()
     * @uses RailType::setCrossBorder()
     * @uses RailType::setDuration()
     * @uses RailType::setMarketingCarrier()
     * @uses RailType::setOperatingCarrier()
     * @uses RailType::setPassengers()
     * @uses RailType::setSupplementaryServices()
     * @uses RailType::setTrainInfo()
     * @uses RailType::setAccommodation()
     * @uses RailType::setStartDetails()
     * @uses RailType::setStopDetails()
     * @uses RailType::setEndDetails()
     * @uses RailType::setRailFares()
     * @uses RailType::setDocuments()
     * @uses RailType::setDetails()
     * @param string $statusCode
     * @param bool $open
     * @param bool $crossBorder
     * @param string $duration
     * @param \Sabre\CreatePassengerNameRecord\Structs\MarketingCarrier $marketingCarrier
     * @param \Sabre\CreatePassengerNameRecord\Structs\ServiceProviderType $operatingCarrier
     * @param \Sabre\CreatePassengerNameRecord\Structs\Passengers $passengers
     * @param \Sabre\CreatePassengerNameRecord\Structs\SupplementaryServices $supplementaryServices
     * @param \Sabre\CreatePassengerNameRecord\Structs\TrainDetailsType $trainInfo
     * @param \Sabre\CreatePassengerNameRecord\Structs\RailAccommodationType[] $accommodation
     * @param \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType $startDetails
     * @param \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType[] $stopDetails
     * @param \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType $endDetails
     * @param \Sabre\CreatePassengerNameRecord\Structs\RailFareType $railFares
     * @param \Sabre\CreatePassengerNameRecord\Structs\Documents $documents
     * @param \Sabre\CreatePassengerNameRecord\Structs\Details $details
     */
    public function __construct($statusCode = null, $open = null, $crossBorder = null, $duration = null, \Sabre\CreatePassengerNameRecord\Structs\MarketingCarrier $marketingCarrier = null, \Sabre\CreatePassengerNameRecord\Structs\ServiceProviderType $operatingCarrier = null, \Sabre\CreatePassengerNameRecord\Structs\Passengers $passengers = null, \Sabre\CreatePassengerNameRecord\Structs\SupplementaryServices $supplementaryServices = null, \Sabre\CreatePassengerNameRecord\Structs\TrainDetailsType $trainInfo = null, array $accommodation = array(), \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType $startDetails = null, array $stopDetails = array(), \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType $endDetails = null, \Sabre\CreatePassengerNameRecord\Structs\RailFareType $railFares = null, \Sabre\CreatePassengerNameRecord\Structs\Documents $documents = null, \Sabre\CreatePassengerNameRecord\Structs\Details $details = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setOpen($open)
            ->setCrossBorder($crossBorder)
            ->setDuration($duration)
            ->setMarketingCarrier($marketingCarrier)
            ->setOperatingCarrier($operatingCarrier)
            ->setPassengers($passengers)
            ->setSupplementaryServices($supplementaryServices)
            ->setTrainInfo($trainInfo)
            ->setAccommodation($accommodation)
            ->setStartDetails($startDetails)
            ->setStopDetails($stopDetails)
            ->setEndDetails($endDetails)
            ->setRailFares($railFares)
            ->setDocuments($documents)
            ->setDetails($details);
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function setStatusCode($statusCode = null)
    {
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get Open value
     * @return bool|null
     */
    public function getOpen()
    {
        return $this->Open;
    }
    /**
     * Set Open value
     * @param bool $open
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function setOpen($open = null)
    {
        $this->Open = $open;
        return $this;
    }
    /**
     * Get CrossBorder value
     * @return bool|null
     */
    public function getCrossBorder()
    {
        return $this->CrossBorder;
    }
    /**
     * Set CrossBorder value
     * @param bool $crossBorder
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function setCrossBorder($crossBorder = null)
    {
        $this->CrossBorder = $crossBorder;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function setDuration($duration = null)
    {
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get MarketingCarrier value
     * @return \Sabre\CreatePassengerNameRecord\Structs\MarketingCarrier|null
     */
    public function getMarketingCarrier()
    {
        return $this->MarketingCarrier;
    }
    /**
     * Set MarketingCarrier value
     * @param \Sabre\CreatePassengerNameRecord\Structs\MarketingCarrier $marketingCarrier
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function setMarketingCarrier(\Sabre\CreatePassengerNameRecord\Structs\MarketingCarrier $marketingCarrier = null)
    {
        $this->MarketingCarrier = $marketingCarrier;
        return $this;
    }
    /**
     * Get OperatingCarrier value
     * @return \Sabre\CreatePassengerNameRecord\Structs\ServiceProviderType|null
     */
    public function getOperatingCarrier()
    {
        return $this->OperatingCarrier;
    }
    /**
     * Set OperatingCarrier value
     * @param \Sabre\CreatePassengerNameRecord\Structs\ServiceProviderType $operatingCarrier
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function setOperatingCarrier(\Sabre\CreatePassengerNameRecord\Structs\ServiceProviderType $operatingCarrier = null)
    {
        $this->OperatingCarrier = $operatingCarrier;
        return $this;
    }
    /**
     * Get Passengers value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Passengers|null
     */
    public function getPassengers()
    {
        return $this->Passengers;
    }
    /**
     * Set Passengers value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Passengers $passengers
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function setPassengers(\Sabre\CreatePassengerNameRecord\Structs\Passengers $passengers = null)
    {
        $this->Passengers = $passengers;
        return $this;
    }
    /**
     * Get SupplementaryServices value
     * @return \Sabre\CreatePassengerNameRecord\Structs\SupplementaryServices|null
     */
    public function getSupplementaryServices()
    {
        return $this->SupplementaryServices;
    }
    /**
     * Set SupplementaryServices value
     * @param \Sabre\CreatePassengerNameRecord\Structs\SupplementaryServices $supplementaryServices
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function setSupplementaryServices(\Sabre\CreatePassengerNameRecord\Structs\SupplementaryServices $supplementaryServices = null)
    {
        $this->SupplementaryServices = $supplementaryServices;
        return $this;
    }
    /**
     * Get TrainInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\TrainDetailsType|null
     */
    public function getTrainInfo()
    {
        return $this->TrainInfo;
    }
    /**
     * Set TrainInfo value
     * @param \Sabre\CreatePassengerNameRecord\Structs\TrainDetailsType $trainInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function setTrainInfo(\Sabre\CreatePassengerNameRecord\Structs\TrainDetailsType $trainInfo = null)
    {
        $this->TrainInfo = $trainInfo;
        return $this;
    }
    /**
     * Get Accommodation value
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailAccommodationType[]|null
     */
    public function getAccommodation()
    {
        return $this->Accommodation;
    }
    /**
     * Set Accommodation value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\RailAccommodationType[] $accommodation
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function setAccommodation(array $accommodation = array())
    {
        $this->Accommodation = $accommodation;
        return $this;
    }
    /**
     * Add item to Accommodation value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\RailAccommodationType $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function addToAccommodation(\Sabre\CreatePassengerNameRecord\Structs\RailAccommodationType $item)
    {
        $this->Accommodation[] = $item;
        return $this;
    }
    /**
     * Get StartDetails value
     * @return \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType|null
     */
    public function getStartDetails()
    {
        return $this->StartDetails;
    }
    /**
     * Set StartDetails value
     * @param \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType $startDetails
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function setStartDetails(\Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType $startDetails = null)
    {
        $this->StartDetails = $startDetails;
        return $this;
    }
    /**
     * Get StopDetails value
     * @return \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType[]|null
     */
    public function getStopDetails()
    {
        return $this->StopDetails;
    }
    /**
     * Set StopDetails value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType[] $stopDetails
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function setStopDetails(array $stopDetails = array())
    {
        $this->StopDetails = $stopDetails;
        return $this;
    }
    /**
     * Add item to StopDetails value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function addToStopDetails(\Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType $item)
    {
        $this->StopDetails[] = $item;
        return $this;
    }
    /**
     * Get EndDetails value
     * @return \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType|null
     */
    public function getEndDetails()
    {
        return $this->EndDetails;
    }
    /**
     * Set EndDetails value
     * @param \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType $endDetails
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function setEndDetails(\Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType $endDetails = null)
    {
        $this->EndDetails = $endDetails;
        return $this;
    }
    /**
     * Get RailFares value
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailFareType|null
     */
    public function getRailFares()
    {
        return $this->RailFares;
    }
    /**
     * Set RailFares value
     * @param \Sabre\CreatePassengerNameRecord\Structs\RailFareType $railFares
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function setRailFares(\Sabre\CreatePassengerNameRecord\Structs\RailFareType $railFares = null)
    {
        $this->RailFares = $railFares;
        return $this;
    }
    /**
     * Get Documents value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Documents|null
     */
    public function getDocuments()
    {
        return $this->Documents;
    }
    /**
     * Set Documents value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Documents $documents
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function setDocuments(\Sabre\CreatePassengerNameRecord\Structs\Documents $documents = null)
    {
        $this->Documents = $documents;
        return $this;
    }
    /**
     * Get Details value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Details|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Details $details
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public function setDetails(\Sabre\CreatePassengerNameRecord\Structs\Details $details = null)
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
