<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonName Structs
 * Meta informations extracted from the WSDL
 * - documentation: PersonName is used to return the passenger name associated with the particular accounting line Example: NameNumber="1.1" TESTA TEST1" | PersonName is the passenger name | PersonName is used to return the passenger name associated
 * with the particular ticketing line Example: NameNumber="1.1" TESTA TEST1" | PersonName contains information about the passenger name | PersonName contains information about the passenger name | "PersonName" is used to return the passenger name
 * associated with the particular SSR segment if applicable
 * @subpackage Structs
 */
class PersonName extends AbstractStructBase
{
    /**
     * The GivenName
     * Meta informations extracted from the WSDL
     * - documentation: "GivenName" is used to return the passenger's given (first) name. | "GivenName" is used to return the policy holder's first name associated with the particular insurance segment.
     * - minOccurs: 0
     * @var string
     */
    public $GivenName;
    /**
     * The GroupInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\GroupInfo
     */
    public $GroupInfo;
    /**
     * The Surname
     * Meta informations extracted from the WSDL
     * - documentation: "Surname" is used to return the passenger's last name. | "Surname" is used to return the policy holder's last name associated with the particular insurance segment.
     * - minOccurs: 0
     * @var string
     */
    public $Surname;
    /**
     * The Infant
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Infant;
    /**
     * The NameNumber
     * Meta informations extracted from the WSDL
     * - documentation: NameNumber is used to return the passenger name number associated with the particular passenger | "NameNumber" is used to return the passenger name number. | NameNumber is used to return the passenger name number associated with the
     * particular passenger | NameNumber is used to return the passenger name number associated with the particular passenger | NameNumber" is used to return the passenger name number associated with the particular SSR segment if applicable
     * - use: optional
     * @var string
     */
    public $NameNumber;
    /**
     * The NameReference
     * Meta informations extracted from the WSDL
     * - documentation: "NameReference" is used to return miscellaneous name reference-related information if applicable.
     * - use: optional
     * @var string
     */
    public $NameReference;
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - documentation: "PassengerType" is used to return the passenger type associated with the particular passenger.
     * - use: optional
     * @var string
     */
    public $PassengerType;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MiddleName;
    /**
     * The DateOfBirth
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: A full date type. Accepted format: "yyyy-mm-dd" | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern: \d{4}-\d{2}-\d{2} |
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $DateOfBirth;
    /**
     * The DocumentHolder
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $DocumentHolder;
    /**
     * The Gender
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Gender;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Email[]
     */
    public $Email;
    /**
     * The ProfileIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\ProfileIndex[]
     */
    public $ProfileIndex;
    /**
     * The WithInfant
     * Meta informations extracted from the WSDL
     * - documentation: "WithInfant" is used to indicate whether or not the passenger is an infant.
     * - use: optional
     * @var string
     */
    public $WithInfant;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference place holder.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for PersonName
     * @uses PersonName::setGivenName()
     * @uses PersonName::setGroupInfo()
     * @uses PersonName::setSurname()
     * @uses PersonName::setInfant()
     * @uses PersonName::setNameNumber()
     * @uses PersonName::setNameReference()
     * @uses PersonName::setPassengerType()
     * @uses PersonName::setMiddleName()
     * @uses PersonName::setDateOfBirth()
     * @uses PersonName::setDocumentHolder()
     * @uses PersonName::setGender()
     * @uses PersonName::set_()
     * @uses PersonName::setEmail()
     * @uses PersonName::setProfileIndex()
     * @uses PersonName::setWithInfant()
     * @uses PersonName::setRPH()
     * @uses PersonName::setId()
     * @param string $givenName
     * @param \Sabre\CreatePassengerNameRecord\Structs\GroupInfo $groupInfo
     * @param string $surname
     * @param bool $infant
     * @param string $nameNumber
     * @param string $nameReference
     * @param string $passengerType
     * @param string $middleName
     * @param string $dateOfBirth
     * @param bool $documentHolder
     * @param string $gender
     * @param string $_
     * @param \Sabre\CreatePassengerNameRecord\Structs\Email[] $email
     * @param \Sabre\CreatePassengerNameRecord\Structs\ProfileIndex[] $profileIndex
     * @param string $withInfant
     * @param string $rPH
     * @param string $id
     */
    public function __construct($givenName = null, \Sabre\CreatePassengerNameRecord\Structs\GroupInfo $groupInfo = null, $surname = null, $infant = null, $nameNumber = null, $nameReference = null, $passengerType = null, $middleName = null, $dateOfBirth = null, $documentHolder = null, $gender = null, $_ = null, array $email = array(), array $profileIndex = array(), $withInfant = null, $rPH = null, $id = null)
    {
        $this
            ->setGivenName($givenName)
            ->setGroupInfo($groupInfo)
            ->setSurname($surname)
            ->setInfant($infant)
            ->setNameNumber($nameNumber)
            ->setNameReference($nameReference)
            ->setPassengerType($passengerType)
            ->setMiddleName($middleName)
            ->setDateOfBirth($dateOfBirth)
            ->setDocumentHolder($documentHolder)
            ->setGender($gender)
            ->set_($_)
            ->setEmail($email)
            ->setProfileIndex($profileIndex)
            ->setWithInfant($withInfant)
            ->setRPH($rPH)
            ->setId($id);
    }
    /**
     * Get GivenName value
     * @return string|null
     */
    public function getGivenName()
    {
        return $this->GivenName;
    }
    /**
     * Set GivenName value
     * @param string $givenName
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function setGivenName($givenName = null)
    {
        $this->GivenName = $givenName;
        return $this;
    }
    /**
     * Get GroupInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\GroupInfo|null
     */
    public function getGroupInfo()
    {
        return $this->GroupInfo;
    }
    /**
     * Set GroupInfo value
     * @param \Sabre\CreatePassengerNameRecord\Structs\GroupInfo $groupInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function setGroupInfo(\Sabre\CreatePassengerNameRecord\Structs\GroupInfo $groupInfo = null)
    {
        $this->GroupInfo = $groupInfo;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function setSurname($surname = null)
    {
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get Infant value
     * @return bool|null
     */
    public function getInfant()
    {
        return $this->Infant;
    }
    /**
     * Set Infant value
     * @param bool $infant
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function setInfant($infant = null)
    {
        $this->Infant = $infant;
        return $this;
    }
    /**
     * Get NameNumber value
     * @return string|null
     */
    public function getNameNumber()
    {
        return $this->NameNumber;
    }
    /**
     * Set NameNumber value
     * @param string $nameNumber
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function setNameNumber($nameNumber = null)
    {
        $this->NameNumber = $nameNumber;
        return $this;
    }
    /**
     * Get NameReference value
     * @return string|null
     */
    public function getNameReference()
    {
        return $this->NameReference;
    }
    /**
     * Set NameReference value
     * @param string $nameReference
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function setNameReference($nameReference = null)
    {
        $this->NameReference = $nameReference;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return string|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param string $passengerType
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function setPassengerType($passengerType = null)
    {
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function setMiddleName($middleName = null)
    {
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get DateOfBirth value
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->DateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param string $dateOfBirth
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        $this->DateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get DocumentHolder value
     * @return bool|null
     */
    public function getDocumentHolder()
    {
        return $this->DocumentHolder;
    }
    /**
     * Set DocumentHolder value
     * @param bool $documentHolder
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function setDocumentHolder($documentHolder = null)
    {
        $this->DocumentHolder = $documentHolder;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function setGender($gender = null)
    {
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Email value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Email[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Email[] $email
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function setEmail(array $email = array())
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Email $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function addToEmail(\Sabre\CreatePassengerNameRecord\Structs\Email $item)
    {
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get ProfileIndex value
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProfileIndex[]|null
     */
    public function getProfileIndex()
    {
        return $this->ProfileIndex;
    }
    /**
     * Set ProfileIndex value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\ProfileIndex[] $profileIndex
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function setProfileIndex(array $profileIndex = array())
    {
        $this->ProfileIndex = $profileIndex;
        return $this;
    }
    /**
     * Add item to ProfileIndex value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\ProfileIndex $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function addToProfileIndex(\Sabre\CreatePassengerNameRecord\Structs\ProfileIndex $item)
    {
        $this->ProfileIndex[] = $item;
        return $this;
    }
    /**
     * Get WithInfant value
     * @return string|null
     */
    public function getWithInfant()
    {
        return $this->WithInfant;
    }
    /**
     * Set WithInfant value
     * @param string $withInfant
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function setWithInfant($withInfant = null)
    {
        $this->WithInfant = $withInfant;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
