<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PACInfo Structs
 * @subpackage Structs
 */
class PACInfo extends AbstractStructBase
{
    /**
     * The PAC
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\PAC[]
     */
    public $PAC;
    /**
     * Constructor method for PACInfo
     * @uses PACInfo::setPAC()
     * @param \Sabre\CreatePassengerNameRecord\Structs\PAC[] $pAC
     */
    public function __construct(array $pAC = array())
    {
        $this
            ->setPAC($pAC);
    }
    /**
     * Get PAC value
     * @return \Sabre\CreatePassengerNameRecord\Structs\PAC[]|null
     */
    public function getPAC()
    {
        return $this->PAC;
    }
    /**
     * Set PAC value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\PAC[] $pAC
     * @return \Sabre\CreatePassengerNameRecord\Structs\PACInfo
     */
    public function setPAC(array $pAC = array())
    {
        $this->PAC = $pAC;
        return $this;
    }
    /**
     * Add item to PAC value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\PAC $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\PACInfo
     */
    public function addToPAC(\Sabre\CreatePassengerNameRecord\Structs\PAC $item)
    {
        $this->PAC[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\PACInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
