<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpenReservationElementType Structs
 * @subpackage Structs
 */
class OpenReservationElementType extends AbstractStructBase
{
    /**
     * The SocialMediaContact
     * @var \Sabre\CreatePassengerNameRecord\Structs\SocialMediaContactType
     */
    public $SocialMediaContact;
    /**
     * The AgencyFees
     * @var \Sabre\CreatePassengerNameRecord\Structs\AgencyFeesType
     */
    public $AgencyFees;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: hold reference ID
     * @var string
     */
    public $id;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: open reservation element type, like SF for Agency Fees
     * @var string
     */
    public $type;
    /**
     * Constructor method for OpenReservationElementType
     * @uses OpenReservationElementType::setSocialMediaContact()
     * @uses OpenReservationElementType::setAgencyFees()
     * @uses OpenReservationElementType::setId()
     * @uses OpenReservationElementType::setType()
     * @param \Sabre\CreatePassengerNameRecord\Structs\SocialMediaContactType $socialMediaContact
     * @param \Sabre\CreatePassengerNameRecord\Structs\AgencyFeesType $agencyFees
     * @param string $id
     * @param string $type
     */
    public function __construct(\Sabre\CreatePassengerNameRecord\Structs\SocialMediaContactType $socialMediaContact = null, \Sabre\CreatePassengerNameRecord\Structs\AgencyFeesType $agencyFees = null, $id = null, $type = null)
    {
        $this
            ->setSocialMediaContact($socialMediaContact)
            ->setAgencyFees($agencyFees)
            ->setId($id)
            ->setType($type);
    }
    /**
     * Get SocialMediaContact value
     * @return \Sabre\CreatePassengerNameRecord\Structs\SocialMediaContactType|null
     */
    public function getSocialMediaContact()
    {
        return $this->SocialMediaContact;
    }
    /**
     * Set SocialMediaContact value
     * @param \Sabre\CreatePassengerNameRecord\Structs\SocialMediaContactType $socialMediaContact
     * @return \Sabre\CreatePassengerNameRecord\Structs\OpenReservationElementType
     */
    public function setSocialMediaContact(\Sabre\CreatePassengerNameRecord\Structs\SocialMediaContactType $socialMediaContact = null)
    {
        $this->SocialMediaContact = $socialMediaContact;
        return $this;
    }
    /**
     * Get AgencyFees value
     * @return \Sabre\CreatePassengerNameRecord\Structs\AgencyFeesType|null
     */
    public function getAgencyFees()
    {
        return $this->AgencyFees;
    }
    /**
     * Set AgencyFees value
     * @param \Sabre\CreatePassengerNameRecord\Structs\AgencyFeesType $agencyFees
     * @return \Sabre\CreatePassengerNameRecord\Structs\OpenReservationElementType
     */
    public function setAgencyFees(\Sabre\CreatePassengerNameRecord\Structs\AgencyFeesType $agencyFees = null)
    {
        $this->AgencyFees = $agencyFees;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \Sabre\CreatePassengerNameRecord\Structs\OpenReservationElementType
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Sabre\CreatePassengerNameRecord\Structs\OpenReservationElementType
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\OpenReservationElementType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
