<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationDetailsType Structs
 * @subpackage Structs
 */
class LocationDetailsType extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\AddressType
     */
    public $Address;
    /**
     * The DateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $DateTime;
    /**
     * The AirportInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\AirportInfoType
     */
    public $AirportInfo;
    /**
     * The RailwayStationInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\RailwayStationInfo
     */
    public $RailwayStationInfo;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Comments;
    /**
     * Constructor method for LocationDetailsType
     * @uses LocationDetailsType::setAddress()
     * @uses LocationDetailsType::setDateTime()
     * @uses LocationDetailsType::setAirportInfo()
     * @uses LocationDetailsType::setRailwayStationInfo()
     * @uses LocationDetailsType::setComments()
     * @param \Sabre\CreatePassengerNameRecord\Structs\AddressType $address
     * @param string $dateTime
     * @param \Sabre\CreatePassengerNameRecord\Structs\AirportInfoType $airportInfo
     * @param \Sabre\CreatePassengerNameRecord\Structs\RailwayStationInfo $railwayStationInfo
     * @param string $comments
     */
    public function __construct(\Sabre\CreatePassengerNameRecord\Structs\AddressType $address = null, $dateTime = null, \Sabre\CreatePassengerNameRecord\Structs\AirportInfoType $airportInfo = null, \Sabre\CreatePassengerNameRecord\Structs\RailwayStationInfo $railwayStationInfo = null, $comments = null)
    {
        $this
            ->setAddress($address)
            ->setDateTime($dateTime)
            ->setAirportInfo($airportInfo)
            ->setRailwayStationInfo($railwayStationInfo)
            ->setComments($comments);
    }
    /**
     * Get Address value
     * @return \Sabre\CreatePassengerNameRecord\Structs\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Sabre\CreatePassengerNameRecord\Structs\AddressType $address
     * @return \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType
     */
    public function setAddress(\Sabre\CreatePassengerNameRecord\Structs\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType
     */
    public function setDateTime($dateTime = null)
    {
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get AirportInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\AirportInfoType|null
     */
    public function getAirportInfo()
    {
        return $this->AirportInfo;
    }
    /**
     * Set AirportInfo value
     * @param \Sabre\CreatePassengerNameRecord\Structs\AirportInfoType $airportInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType
     */
    public function setAirportInfo(\Sabre\CreatePassengerNameRecord\Structs\AirportInfoType $airportInfo = null)
    {
        $this->AirportInfo = $airportInfo;
        return $this;
    }
    /**
     * Get RailwayStationInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\RailwayStationInfo|null
     */
    public function getRailwayStationInfo()
    {
        return $this->RailwayStationInfo;
    }
    /**
     * Set RailwayStationInfo value
     * @param \Sabre\CreatePassengerNameRecord\Structs\RailwayStationInfo $railwayStationInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType
     */
    public function setRailwayStationInfo(\Sabre\CreatePassengerNameRecord\Structs\RailwayStationInfo $railwayStationInfo = null)
    {
        $this->RailwayStationInfo = $railwayStationInfo;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType
     */
    public function setComments($comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\LocationDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
