<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item Structs
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The TicketingCarrier
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $TicketingCarrier;
    /**
     * The ValidatingCarrier
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ValidatingCarrier;
    /**
     * The SalePseudoCityCode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $SalePseudoCityCode;
    /**
     * The AirFareInfo
     * @var \Sabre\CreatePassengerNameRecord\Structs\AirFareInfo
     */
    public $AirFareInfo;
    /**
     * The FlightSegment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\FlightSegment[]
     */
    public $FlightSegment;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference placeholder.
     * - use: optional
     * @var int
     */
    public $RPH;
    /**
     * The AirTaxi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\AirTaxi
     */
    public $AirTaxi;
    /**
     * The Arunk
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Arunk
     */
    public $Arunk;
    /**
     * The Cruise
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Cruise
     */
    public $Cruise;
    /**
     * The Hotel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Hotel
     */
    public $Hotel;
    /**
     * The Insurance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Insurance
     */
    public $Insurance;
    /**
     * The MiscSegment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\MiscSegment
     */
    public $MiscSegment;
    /**
     * The Rail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Rail
     */
    public $Rail;
    /**
     * The Seats
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Seats
     */
    public $Seats;
    /**
     * The Surface
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Surface
     */
    public $Surface;
    /**
     * The Tour
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Tour
     */
    public $Tour;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Vehicle
     */
    public $Vehicle;
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\ProductType
     */
    public $Product;
    /**
     * The Ancillaries
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Ancillaries
     */
    public $Ancillaries;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Item
     * @uses Item::setTicketingCarrier()
     * @uses Item::setValidatingCarrier()
     * @uses Item::setSalePseudoCityCode()
     * @uses Item::setAirFareInfo()
     * @uses Item::setFlightSegment()
     * @uses Item::setRPH()
     * @uses Item::setAirTaxi()
     * @uses Item::setArunk()
     * @uses Item::setCruise()
     * @uses Item::setHotel()
     * @uses Item::setInsurance()
     * @uses Item::setMiscSegment()
     * @uses Item::setRail()
     * @uses Item::setSeats()
     * @uses Item::setSurface()
     * @uses Item::setTour()
     * @uses Item::setVehicle()
     * @uses Item::setProduct()
     * @uses Item::setAncillaries()
     * @uses Item::setId()
     * @param string $ticketingCarrier
     * @param string $validatingCarrier
     * @param string $salePseudoCityCode
     * @param \Sabre\CreatePassengerNameRecord\Structs\AirFareInfo $airFareInfo
     * @param \Sabre\CreatePassengerNameRecord\Structs\FlightSegment[] $flightSegment
     * @param int $rPH
     * @param \Sabre\CreatePassengerNameRecord\Structs\AirTaxi $airTaxi
     * @param \Sabre\CreatePassengerNameRecord\Structs\Arunk $arunk
     * @param \Sabre\CreatePassengerNameRecord\Structs\Cruise $cruise
     * @param \Sabre\CreatePassengerNameRecord\Structs\Hotel $hotel
     * @param \Sabre\CreatePassengerNameRecord\Structs\Insurance $insurance
     * @param \Sabre\CreatePassengerNameRecord\Structs\MiscSegment $miscSegment
     * @param \Sabre\CreatePassengerNameRecord\Structs\Rail $rail
     * @param \Sabre\CreatePassengerNameRecord\Structs\Seats $seats
     * @param \Sabre\CreatePassengerNameRecord\Structs\Surface $surface
     * @param \Sabre\CreatePassengerNameRecord\Structs\Tour $tour
     * @param \Sabre\CreatePassengerNameRecord\Structs\Vehicle $vehicle
     * @param \Sabre\CreatePassengerNameRecord\Structs\ProductType $product
     * @param \Sabre\CreatePassengerNameRecord\Structs\Ancillaries $ancillaries
     * @param string $id
     */
    public function __construct($ticketingCarrier = null, $validatingCarrier = null, $salePseudoCityCode = null, \Sabre\CreatePassengerNameRecord\Structs\AirFareInfo $airFareInfo = null, array $flightSegment = array(), $rPH = null, \Sabre\CreatePassengerNameRecord\Structs\AirTaxi $airTaxi = null, \Sabre\CreatePassengerNameRecord\Structs\Arunk $arunk = null, \Sabre\CreatePassengerNameRecord\Structs\Cruise $cruise = null, \Sabre\CreatePassengerNameRecord\Structs\Hotel $hotel = null, \Sabre\CreatePassengerNameRecord\Structs\Insurance $insurance = null, \Sabre\CreatePassengerNameRecord\Structs\MiscSegment $miscSegment = null, \Sabre\CreatePassengerNameRecord\Structs\Rail $rail = null, \Sabre\CreatePassengerNameRecord\Structs\Seats $seats = null, \Sabre\CreatePassengerNameRecord\Structs\Surface $surface = null, \Sabre\CreatePassengerNameRecord\Structs\Tour $tour = null, \Sabre\CreatePassengerNameRecord\Structs\Vehicle $vehicle = null, \Sabre\CreatePassengerNameRecord\Structs\ProductType $product = null, \Sabre\CreatePassengerNameRecord\Structs\Ancillaries $ancillaries = null, $id = null)
    {
        $this
            ->setTicketingCarrier($ticketingCarrier)
            ->setValidatingCarrier($validatingCarrier)
            ->setSalePseudoCityCode($salePseudoCityCode)
            ->setAirFareInfo($airFareInfo)
            ->setFlightSegment($flightSegment)
            ->setRPH($rPH)
            ->setAirTaxi($airTaxi)
            ->setArunk($arunk)
            ->setCruise($cruise)
            ->setHotel($hotel)
            ->setInsurance($insurance)
            ->setMiscSegment($miscSegment)
            ->setRail($rail)
            ->setSeats($seats)
            ->setSurface($surface)
            ->setTour($tour)
            ->setVehicle($vehicle)
            ->setProduct($product)
            ->setAncillaries($ancillaries)
            ->setId($id);
    }
    /**
     * Get TicketingCarrier value
     * @return string
     */
    public function getTicketingCarrier()
    {
        return $this->TicketingCarrier;
    }
    /**
     * Set TicketingCarrier value
     * @param string $ticketingCarrier
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setTicketingCarrier($ticketingCarrier = null)
    {
        $this->TicketingCarrier = $ticketingCarrier;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return string
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param string $validatingCarrier
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setValidatingCarrier($validatingCarrier = null)
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
    /**
     * Get SalePseudoCityCode value
     * @return string
     */
    public function getSalePseudoCityCode()
    {
        return $this->SalePseudoCityCode;
    }
    /**
     * Set SalePseudoCityCode value
     * @param string $salePseudoCityCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setSalePseudoCityCode($salePseudoCityCode = null)
    {
        $this->SalePseudoCityCode = $salePseudoCityCode;
        return $this;
    }
    /**
     * Get AirFareInfo value
     * @return \Sabre\CreatePassengerNameRecord\Structs\AirFareInfo|null
     */
    public function getAirFareInfo()
    {
        return $this->AirFareInfo;
    }
    /**
     * Set AirFareInfo value
     * @param \Sabre\CreatePassengerNameRecord\Structs\AirFareInfo $airFareInfo
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setAirFareInfo(\Sabre\CreatePassengerNameRecord\Structs\AirFareInfo $airFareInfo = null)
    {
        $this->AirFareInfo = $airFareInfo;
        return $this;
    }
    /**
     * Get FlightSegment value
     * @return \Sabre\CreatePassengerNameRecord\Structs\FlightSegment[]|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\FlightSegment[] $flightSegment
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setFlightSegment(array $flightSegment = array())
    {
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Add item to FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\FlightSegment $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function addToFlightSegment(\Sabre\CreatePassengerNameRecord\Structs\FlightSegment $item)
    {
        $this->FlightSegment[] = $item;
        return $this;
    }
    /**
     * Get RPH value
     * @return int|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param int $rPH
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get AirTaxi value
     * @return \Sabre\CreatePassengerNameRecord\Structs\AirTaxi|null
     */
    public function getAirTaxi()
    {
        return $this->AirTaxi;
    }
    /**
     * Set AirTaxi value
     * @param \Sabre\CreatePassengerNameRecord\Structs\AirTaxi $airTaxi
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setAirTaxi(\Sabre\CreatePassengerNameRecord\Structs\AirTaxi $airTaxi = null)
    {
        $this->AirTaxi = $airTaxi;
        return $this;
    }
    /**
     * Get Arunk value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Arunk|null
     */
    public function getArunk()
    {
        return $this->Arunk;
    }
    /**
     * Set Arunk value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Arunk $arunk
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setArunk(\Sabre\CreatePassengerNameRecord\Structs\Arunk $arunk = null)
    {
        $this->Arunk = $arunk;
        return $this;
    }
    /**
     * Get Cruise value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Cruise|null
     */
    public function getCruise()
    {
        return $this->Cruise;
    }
    /**
     * Set Cruise value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Cruise $cruise
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setCruise(\Sabre\CreatePassengerNameRecord\Structs\Cruise $cruise = null)
    {
        $this->Cruise = $cruise;
        return $this;
    }
    /**
     * Get Hotel value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Hotel|null
     */
    public function getHotel()
    {
        return $this->Hotel;
    }
    /**
     * Set Hotel value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Hotel $hotel
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setHotel(\Sabre\CreatePassengerNameRecord\Structs\Hotel $hotel = null)
    {
        $this->Hotel = $hotel;
        return $this;
    }
    /**
     * Get Insurance value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Insurance|null
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }
    /**
     * Set Insurance value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Insurance $insurance
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setInsurance(\Sabre\CreatePassengerNameRecord\Structs\Insurance $insurance = null)
    {
        $this->Insurance = $insurance;
        return $this;
    }
    /**
     * Get MiscSegment value
     * @return \Sabre\CreatePassengerNameRecord\Structs\MiscSegment|null
     */
    public function getMiscSegment()
    {
        return $this->MiscSegment;
    }
    /**
     * Set MiscSegment value
     * @param \Sabre\CreatePassengerNameRecord\Structs\MiscSegment $miscSegment
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setMiscSegment(\Sabre\CreatePassengerNameRecord\Structs\MiscSegment $miscSegment = null)
    {
        $this->MiscSegment = $miscSegment;
        return $this;
    }
    /**
     * Get Rail value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Rail|null
     */
    public function getRail()
    {
        return $this->Rail;
    }
    /**
     * Set Rail value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Rail $rail
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setRail(\Sabre\CreatePassengerNameRecord\Structs\Rail $rail = null)
    {
        $this->Rail = $rail;
        return $this;
    }
    /**
     * Get Seats value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Seats|null
     */
    public function getSeats()
    {
        return $this->Seats;
    }
    /**
     * Set Seats value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Seats $seats
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setSeats(\Sabre\CreatePassengerNameRecord\Structs\Seats $seats = null)
    {
        $this->Seats = $seats;
        return $this;
    }
    /**
     * Get Surface value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Surface|null
     */
    public function getSurface()
    {
        return $this->Surface;
    }
    /**
     * Set Surface value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Surface $surface
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setSurface(\Sabre\CreatePassengerNameRecord\Structs\Surface $surface = null)
    {
        $this->Surface = $surface;
        return $this;
    }
    /**
     * Get Tour value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Tour|null
     */
    public function getTour()
    {
        return $this->Tour;
    }
    /**
     * Set Tour value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Tour $tour
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setTour(\Sabre\CreatePassengerNameRecord\Structs\Tour $tour = null)
    {
        $this->Tour = $tour;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Vehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Vehicle $vehicle
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setVehicle(\Sabre\CreatePassengerNameRecord\Structs\Vehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Product value
     * @return \Sabre\CreatePassengerNameRecord\Structs\ProductType|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \Sabre\CreatePassengerNameRecord\Structs\ProductType $product
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setProduct(\Sabre\CreatePassengerNameRecord\Structs\ProductType $product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Get Ancillaries value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Ancillaries|null
     */
    public function getAncillaries()
    {
        return $this->Ancillaries;
    }
    /**
     * Set Ancillaries value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Ancillaries $ancillaries
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setAncillaries(\Sabre\CreatePassengerNameRecord\Structs\Ancillaries $ancillaries = null)
    {
        $this->Ancillaries = $ancillaries;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\Item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
