<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareCalculationBreakdown Structs
 * @subpackage Structs
 */
class FareCalculationBreakdown extends AbstractStructBase
{
    /**
     * The Branch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Branch
     */
    public $Branch;
    /**
     * The Departure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Departure
     */
    public $Departure;
    /**
     * The FareBasis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\FareBasis
     */
    public $FareBasis;
    /**
     * The FreeBaggageAllowance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FreeBaggageAllowance;
    /**
     * The Mileage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Mileage
     */
    public $Mileage;
    /**
     * The RuleCategoryIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 28
     * - minOccurs: 0
     * @var string[]
     */
    public $RuleCategoryIndicator;
    /**
     * The Surcharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Surcharges[]
     */
    public $Surcharges;
    /**
     * The StopoverCharge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\StopoverCharge
     */
    public $StopoverCharge;
    /**
     * Constructor method for FareCalculationBreakdown
     * @uses FareCalculationBreakdown::setBranch()
     * @uses FareCalculationBreakdown::setDeparture()
     * @uses FareCalculationBreakdown::setFareBasis()
     * @uses FareCalculationBreakdown::setFreeBaggageAllowance()
     * @uses FareCalculationBreakdown::setMileage()
     * @uses FareCalculationBreakdown::setRuleCategoryIndicator()
     * @uses FareCalculationBreakdown::setSurcharges()
     * @uses FareCalculationBreakdown::setStopoverCharge()
     * @param \Sabre\CreatePassengerNameRecord\Structs\Branch $branch
     * @param \Sabre\CreatePassengerNameRecord\Structs\Departure $departure
     * @param \Sabre\CreatePassengerNameRecord\Structs\FareBasis $fareBasis
     * @param string $freeBaggageAllowance
     * @param \Sabre\CreatePassengerNameRecord\Structs\Mileage $mileage
     * @param string[] $ruleCategoryIndicator
     * @param \Sabre\CreatePassengerNameRecord\Structs\Surcharges[] $surcharges
     * @param \Sabre\CreatePassengerNameRecord\Structs\StopoverCharge $stopoverCharge
     */
    public function __construct(\Sabre\CreatePassengerNameRecord\Structs\Branch $branch = null, \Sabre\CreatePassengerNameRecord\Structs\Departure $departure = null, \Sabre\CreatePassengerNameRecord\Structs\FareBasis $fareBasis = null, $freeBaggageAllowance = null, \Sabre\CreatePassengerNameRecord\Structs\Mileage $mileage = null, array $ruleCategoryIndicator = array(), array $surcharges = array(), \Sabre\CreatePassengerNameRecord\Structs\StopoverCharge $stopoverCharge = null)
    {
        $this
            ->setBranch($branch)
            ->setDeparture($departure)
            ->setFareBasis($fareBasis)
            ->setFreeBaggageAllowance($freeBaggageAllowance)
            ->setMileage($mileage)
            ->setRuleCategoryIndicator($ruleCategoryIndicator)
            ->setSurcharges($surcharges)
            ->setStopoverCharge($stopoverCharge);
    }
    /**
     * Get Branch value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Branch|null
     */
    public function getBranch()
    {
        return $this->Branch;
    }
    /**
     * Set Branch value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Branch $branch
     * @return \Sabre\CreatePassengerNameRecord\Structs\FareCalculationBreakdown
     */
    public function setBranch(\Sabre\CreatePassengerNameRecord\Structs\Branch $branch = null)
    {
        $this->Branch = $branch;
        return $this;
    }
    /**
     * Get Departure value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Departure|null
     */
    public function getDeparture()
    {
        return $this->Departure;
    }
    /**
     * Set Departure value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Departure $departure
     * @return \Sabre\CreatePassengerNameRecord\Structs\FareCalculationBreakdown
     */
    public function setDeparture(\Sabre\CreatePassengerNameRecord\Structs\Departure $departure = null)
    {
        $this->Departure = $departure;
        return $this;
    }
    /**
     * Get FareBasis value
     * @return \Sabre\CreatePassengerNameRecord\Structs\FareBasis|null
     */
    public function getFareBasis()
    {
        return $this->FareBasis;
    }
    /**
     * Set FareBasis value
     * @param \Sabre\CreatePassengerNameRecord\Structs\FareBasis $fareBasis
     * @return \Sabre\CreatePassengerNameRecord\Structs\FareCalculationBreakdown
     */
    public function setFareBasis(\Sabre\CreatePassengerNameRecord\Structs\FareBasis $fareBasis = null)
    {
        $this->FareBasis = $fareBasis;
        return $this;
    }
    /**
     * Get FreeBaggageAllowance value
     * @return string|null
     */
    public function getFreeBaggageAllowance()
    {
        return $this->FreeBaggageAllowance;
    }
    /**
     * Set FreeBaggageAllowance value
     * @param string $freeBaggageAllowance
     * @return \Sabre\CreatePassengerNameRecord\Structs\FareCalculationBreakdown
     */
    public function setFreeBaggageAllowance($freeBaggageAllowance = null)
    {
        $this->FreeBaggageAllowance = $freeBaggageAllowance;
        return $this;
    }
    /**
     * Get Mileage value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Mileage|null
     */
    public function getMileage()
    {
        return $this->Mileage;
    }
    /**
     * Set Mileage value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Mileage $mileage
     * @return \Sabre\CreatePassengerNameRecord\Structs\FareCalculationBreakdown
     */
    public function setMileage(\Sabre\CreatePassengerNameRecord\Structs\Mileage $mileage = null)
    {
        $this->Mileage = $mileage;
        return $this;
    }
    /**
     * Get RuleCategoryIndicator value
     * @return string[]|null
     */
    public function getRuleCategoryIndicator()
    {
        return $this->RuleCategoryIndicator;
    }
    /**
     * Set RuleCategoryIndicator value
     * @throws \InvalidArgumentException
     * @param string[] $ruleCategoryIndicator
     * @return \Sabre\CreatePassengerNameRecord\Structs\FareCalculationBreakdown
     */
    public function setRuleCategoryIndicator(array $ruleCategoryIndicator = array())
    {
        $this->RuleCategoryIndicator = $ruleCategoryIndicator;
        return $this;
    }
    /**
     * Add item to RuleCategoryIndicator value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\FareCalculationBreakdown
     */
    public function addToRuleCategoryIndicator($item)
    {
        $this->RuleCategoryIndicator[] = $item;
        return $this;
    }
    /**
     * Get Surcharges value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Surcharges[]|null
     */
    public function getSurcharges()
    {
        return $this->Surcharges;
    }
    /**
     * Set Surcharges value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Surcharges[] $surcharges
     * @return \Sabre\CreatePassengerNameRecord\Structs\FareCalculationBreakdown
     */
    public function setSurcharges(array $surcharges = array())
    {
        $this->Surcharges = $surcharges;
        return $this;
    }
    /**
     * Add item to Surcharges value
     * @throws \InvalidArgumentException
     * @param \Sabre\CreatePassengerNameRecord\Structs\Surcharges $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\FareCalculationBreakdown
     */
    public function addToSurcharges(\Sabre\CreatePassengerNameRecord\Structs\Surcharges $item)
    {
        $this->Surcharges[] = $item;
        return $this;
    }
    /**
     * Get StopoverCharge value
     * @return \Sabre\CreatePassengerNameRecord\Structs\StopoverCharge|null
     */
    public function getStopoverCharge()
    {
        return $this->StopoverCharge;
    }
    /**
     * Set StopoverCharge value
     * @param \Sabre\CreatePassengerNameRecord\Structs\StopoverCharge $stopoverCharge
     * @return \Sabre\CreatePassengerNameRecord\Structs\FareCalculationBreakdown
     */
    public function setStopoverCharge(\Sabre\CreatePassengerNameRecord\Structs\StopoverCharge $stopoverCharge = null)
    {
        $this->StopoverCharge = $stopoverCharge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\FareCalculationBreakdown
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
