<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Email Structs
 * Meta informations extracted from the WSDL
 * - documentation: "Email" is used to return the passenger's email address.
 * @subpackage Structs
 */
class Email extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Address;
    /**
     * The Ind
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Ind;
    /**
     * The NameNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $NameNumber;
    /**
     * The ShortText
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ShortText;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The eTicket
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\ETicket
     */
    public $eTicket;
    /**
     * The Invoice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Invoice
     */
    public $Invoice;
    /**
     * The Itinerary
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Itinerary
     */
    public $Itinerary;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\PersonName
     */
    public $PersonName;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for Email
     * @uses Email::setAddress()
     * @uses Email::setInd()
     * @uses Email::setNameNumber()
     * @uses Email::setShortText()
     * @uses Email::setType()
     * @uses Email::setETicket()
     * @uses Email::setInvoice()
     * @uses Email::setItinerary()
     * @uses Email::setPersonName()
     * @uses Email::set_()
     * @uses Email::setId()
     * @uses Email::setComment()
     * @param string $address
     * @param bool $ind
     * @param string $nameNumber
     * @param string $shortText
     * @param string $type
     * @param \Sabre\CreatePassengerNameRecord\Structs\ETicket $eTicket
     * @param \Sabre\CreatePassengerNameRecord\Structs\Invoice $invoice
     * @param \Sabre\CreatePassengerNameRecord\Structs\Itinerary $itinerary
     * @param \Sabre\CreatePassengerNameRecord\Structs\PersonName $personName
     * @param string $_
     * @param string $id
     * @param string $comment
     */
    public function __construct($address = null, $ind = null, $nameNumber = null, $shortText = null, $type = null, \Sabre\CreatePassengerNameRecord\Structs\ETicket $eTicket = null, \Sabre\CreatePassengerNameRecord\Structs\Invoice $invoice = null, \Sabre\CreatePassengerNameRecord\Structs\Itinerary $itinerary = null, \Sabre\CreatePassengerNameRecord\Structs\PersonName $personName = null, $_ = null, $id = null, $comment = null)
    {
        $this
            ->setAddress($address)
            ->setInd($ind)
            ->setNameNumber($nameNumber)
            ->setShortText($shortText)
            ->setType($type)
            ->setETicket($eTicket)
            ->setInvoice($invoice)
            ->setItinerary($itinerary)
            ->setPersonName($personName)
            ->set_($_)
            ->setId($id)
            ->setComment($comment);
    }
    /**
     * Get Address value
     * @return string
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \Sabre\CreatePassengerNameRecord\Structs\Email
     */
    public function setAddress($address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Ind value
     * @return bool
     */
    public function getInd()
    {
        return $this->Ind;
    }
    /**
     * Set Ind value
     * @param bool $ind
     * @return \Sabre\CreatePassengerNameRecord\Structs\Email
     */
    public function setInd($ind = null)
    {
        $this->Ind = $ind;
        return $this;
    }
    /**
     * Get NameNumber value
     * @return string|null
     */
    public function getNameNumber()
    {
        return $this->NameNumber;
    }
    /**
     * Set NameNumber value
     * @param string $nameNumber
     * @return \Sabre\CreatePassengerNameRecord\Structs\Email
     */
    public function setNameNumber($nameNumber = null)
    {
        $this->NameNumber = $nameNumber;
        return $this;
    }
    /**
     * Get ShortText value
     * @return string|null
     */
    public function getShortText()
    {
        return $this->ShortText;
    }
    /**
     * Set ShortText value
     * @param string $shortText
     * @return \Sabre\CreatePassengerNameRecord\Structs\Email
     */
    public function setShortText($shortText = null)
    {
        $this->ShortText = $shortText;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\CreatePassengerNameRecord\Structs\Email
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get eTicket value
     * @return \Sabre\CreatePassengerNameRecord\Structs\ETicket|null
     */
    public function getETicket()
    {
        return $this->eTicket;
    }
    /**
     * Set eTicket value
     * @param \Sabre\CreatePassengerNameRecord\Structs\ETicket $eTicket
     * @return \Sabre\CreatePassengerNameRecord\Structs\Email
     */
    public function setETicket(\Sabre\CreatePassengerNameRecord\Structs\ETicket $eTicket = null)
    {
        $this->eTicket = $eTicket;
        return $this;
    }
    /**
     * Get Invoice value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Invoice|null
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Invoice $invoice
     * @return \Sabre\CreatePassengerNameRecord\Structs\Email
     */
    public function setInvoice(\Sabre\CreatePassengerNameRecord\Structs\Invoice $invoice = null)
    {
        $this->Invoice = $invoice;
        return $this;
    }
    /**
     * Get Itinerary value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Itinerary|null
     */
    public function getItinerary()
    {
        return $this->Itinerary;
    }
    /**
     * Set Itinerary value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Itinerary $itinerary
     * @return \Sabre\CreatePassengerNameRecord\Structs\Email
     */
    public function setItinerary(\Sabre\CreatePassengerNameRecord\Structs\Itinerary $itinerary = null)
    {
        $this->Itinerary = $itinerary;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\CreatePassengerNameRecord\Structs\PersonName|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\CreatePassengerNameRecord\Structs\PersonName $personName
     * @return \Sabre\CreatePassengerNameRecord\Structs\Email
     */
    public function setPersonName(\Sabre\CreatePassengerNameRecord\Structs\PersonName $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\CreatePassengerNameRecord\Structs\Email
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\CreatePassengerNameRecord\Structs\Email
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \Sabre\CreatePassengerNameRecord\Structs\Email
     */
    public function setComment($comment = null)
    {
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\Email
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
