<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Departure Structs
 * @subpackage Structs
 */
class Departure extends AbstractStructBase
{
    /**
     * The CityCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CityCode;
    /**
     * The AirportCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AirportCode;
    /**
     * The SideTripIndicator
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SideTripIndicator;
    /**
     * The AirlineCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AirlineCode;
    /**
     * The GenericInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $GenericInd;
    /**
     * The GlobalInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $GlobalInd;
    /**
     * The ArrivalCityCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ArrivalCityCode;
    /**
     * The ArrivalAirportCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ArrivalAirportCode;
    /**
     * The InfantFareConstructionCity
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $InfantFareConstructionCity;
    /**
     * Constructor method for Departure
     * @uses Departure::setCityCode()
     * @uses Departure::setAirportCode()
     * @uses Departure::setSideTripIndicator()
     * @uses Departure::setAirlineCode()
     * @uses Departure::setGenericInd()
     * @uses Departure::setGlobalInd()
     * @uses Departure::setArrivalCityCode()
     * @uses Departure::setArrivalAirportCode()
     * @uses Departure::setInfantFareConstructionCity()
     * @param string $cityCode
     * @param string $airportCode
     * @param string $sideTripIndicator
     * @param string $airlineCode
     * @param string $genericInd
     * @param string $globalInd
     * @param string $arrivalCityCode
     * @param string $arrivalAirportCode
     * @param string $infantFareConstructionCity
     */
    public function __construct($cityCode = null, $airportCode = null, $sideTripIndicator = null, $airlineCode = null, $genericInd = null, $globalInd = null, $arrivalCityCode = null, $arrivalAirportCode = null, $infantFareConstructionCity = null)
    {
        $this
            ->setCityCode($cityCode)
            ->setAirportCode($airportCode)
            ->setSideTripIndicator($sideTripIndicator)
            ->setAirlineCode($airlineCode)
            ->setGenericInd($genericInd)
            ->setGlobalInd($globalInd)
            ->setArrivalCityCode($arrivalCityCode)
            ->setArrivalAirportCode($arrivalAirportCode)
            ->setInfantFareConstructionCity($infantFareConstructionCity);
    }
    /**
     * Get CityCode value
     * @return string|null
     */
    public function getCityCode()
    {
        return $this->CityCode;
    }
    /**
     * Set CityCode value
     * @param string $cityCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Departure
     */
    public function setCityCode($cityCode = null)
    {
        $this->CityCode = $cityCode;
        return $this;
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Departure
     */
    public function setAirportCode($airportCode = null)
    {
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Get SideTripIndicator value
     * @return string|null
     */
    public function getSideTripIndicator()
    {
        return $this->SideTripIndicator;
    }
    /**
     * Set SideTripIndicator value
     * @param string $sideTripIndicator
     * @return \Sabre\CreatePassengerNameRecord\Structs\Departure
     */
    public function setSideTripIndicator($sideTripIndicator = null)
    {
        $this->SideTripIndicator = $sideTripIndicator;
        return $this;
    }
    /**
     * Get AirlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Departure
     */
    public function setAirlineCode($airlineCode = null)
    {
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get GenericInd value
     * @return string|null
     */
    public function getGenericInd()
    {
        return $this->GenericInd;
    }
    /**
     * Set GenericInd value
     * @param string $genericInd
     * @return \Sabre\CreatePassengerNameRecord\Structs\Departure
     */
    public function setGenericInd($genericInd = null)
    {
        $this->GenericInd = $genericInd;
        return $this;
    }
    /**
     * Get GlobalInd value
     * @return string|null
     */
    public function getGlobalInd()
    {
        return $this->GlobalInd;
    }
    /**
     * Set GlobalInd value
     * @param string $globalInd
     * @return \Sabre\CreatePassengerNameRecord\Structs\Departure
     */
    public function setGlobalInd($globalInd = null)
    {
        $this->GlobalInd = $globalInd;
        return $this;
    }
    /**
     * Get ArrivalCityCode value
     * @return string|null
     */
    public function getArrivalCityCode()
    {
        return $this->ArrivalCityCode;
    }
    /**
     * Set ArrivalCityCode value
     * @param string $arrivalCityCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Departure
     */
    public function setArrivalCityCode($arrivalCityCode = null)
    {
        $this->ArrivalCityCode = $arrivalCityCode;
        return $this;
    }
    /**
     * Get ArrivalAirportCode value
     * @return string|null
     */
    public function getArrivalAirportCode()
    {
        return $this->ArrivalAirportCode;
    }
    /**
     * Set ArrivalAirportCode value
     * @param string $arrivalAirportCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Departure
     */
    public function setArrivalAirportCode($arrivalAirportCode = null)
    {
        $this->ArrivalAirportCode = $arrivalAirportCode;
        return $this;
    }
    /**
     * Get InfantFareConstructionCity value
     * @return string|null
     */
    public function getInfantFareConstructionCity()
    {
        return $this->InfantFareConstructionCity;
    }
    /**
     * Set InfantFareConstructionCity value
     * @param string $infantFareConstructionCity
     * @return \Sabre\CreatePassengerNameRecord\Structs\Departure
     */
    public function setInfantFareConstructionCity($infantFareConstructionCity = null)
    {
        $this->InfantFareConstructionCity = $infantFareConstructionCity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\Departure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
