<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Commission Structs
 * Meta informations extracted from the WSDL
 * - documentation: Commission is used as a place holder for commission associated with the particular accounting line Example: Commission Amount="31.00" Percent="1" | "Commission" is used to return commission-related information. | "Commission" is used
 * to return commission-related information.
 * @subpackage Structs
 */
class Commission extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return the commission amount associated with the particular hotel reservation if applicable. | "Amount" is used to return the commission amount if applicable.
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The Percent
     * Meta informations extracted from the WSDL
     * - documentation: "Percent" is used to return the commission percentage associated with the particular hotel reservation if applicable. | "Percent" is used to return the commission percentage if applicable.
     * - minOccurs: 0
     * - use: optional
     * @var string
     */
    public $Percent;
    /**
     * The CapAmountInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CapAmountInd;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The NonCommission
     * Meta informations extracted from the WSDL
     * - documentation: "NonCommission" is used to return non-commission-related information.
     * - use: optional
     * @var bool
     */
    public $NonCommission;
    /**
     * The Indicator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Indicator;
    /**
     * The PerNight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PerNight;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * Constructor method for Commission
     * @uses Commission::setAmount()
     * @uses Commission::setPercent()
     * @uses Commission::setCapAmountInd()
     * @uses Commission::setCurrencyCode()
     * @uses Commission::set_()
     * @uses Commission::setNonCommission()
     * @uses Commission::setIndicator()
     * @uses Commission::setPerNight()
     * @uses Commission::setText()
     * @param string $amount
     * @param string $percent
     * @param string $capAmountInd
     * @param string $currencyCode
     * @param string $_
     * @param bool $nonCommission
     * @param string $indicator
     * @param string $perNight
     * @param string $text
     */
    public function __construct($amount = null, $percent = null, $capAmountInd = null, $currencyCode = null, $_ = null, $nonCommission = null, $indicator = null, $perNight = null, $text = null)
    {
        $this
            ->setAmount($amount)
            ->setPercent($percent)
            ->setCapAmountInd($capAmountInd)
            ->setCurrencyCode($currencyCode)
            ->set_($_)
            ->setNonCommission($nonCommission)
            ->setIndicator($indicator)
            ->setPerNight($perNight)
            ->setText($text);
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\CreatePassengerNameRecord\Structs\Commission
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Percent value
     * @return string|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param string $percent
     * @return \Sabre\CreatePassengerNameRecord\Structs\Commission
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get CapAmountInd value
     * @return string|null
     */
    public function getCapAmountInd()
    {
        return $this->CapAmountInd;
    }
    /**
     * Set CapAmountInd value
     * @param string $capAmountInd
     * @return \Sabre\CreatePassengerNameRecord\Structs\Commission
     */
    public function setCapAmountInd($capAmountInd = null)
    {
        $this->CapAmountInd = $capAmountInd;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\CreatePassengerNameRecord\Structs\Commission
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\CreatePassengerNameRecord\Structs\Commission
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get NonCommission value
     * @return bool|null
     */
    public function getNonCommission()
    {
        return $this->NonCommission;
    }
    /**
     * Set NonCommission value
     * @param bool $nonCommission
     * @return \Sabre\CreatePassengerNameRecord\Structs\Commission
     */
    public function setNonCommission($nonCommission = null)
    {
        $this->NonCommission = $nonCommission;
        return $this;
    }
    /**
     * Get Indicator value
     * @return string|null
     */
    public function getIndicator()
    {
        return $this->Indicator;
    }
    /**
     * Set Indicator value
     * @param string $indicator
     * @return \Sabre\CreatePassengerNameRecord\Structs\Commission
     */
    public function setIndicator($indicator = null)
    {
        $this->Indicator = $indicator;
        return $this;
    }
    /**
     * Get PerNight value
     * @return string|null
     */
    public function getPerNight()
    {
        return $this->PerNight;
    }
    /**
     * Set PerNight value
     * @param string $perNight
     * @return \Sabre\CreatePassengerNameRecord\Structs\Commission
     */
    public function setPerNight($perNight = null)
    {
        $this->PerNight = $perNight;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\CreatePassengerNameRecord\Structs\Commission
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\Commission
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
