<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CollectionInfo Structs
 * @subpackage Structs
 */
class CollectionInfo extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\Address
     */
    public $Address;
    /**
     * The ContactNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\CreatePassengerNameRecord\Structs\ContactNumbers
     */
    public $ContactNumbers;
    /**
     * The SiteID
     * Meta informations extracted from the WSDL
     * - documentation: "SiteID" is used to return the collection site ID associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $SiteID;
    /**
     * The SiteName
     * Meta informations extracted from the WSDL
     * - documentation: "SiteName" is used to return the collection site name associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $SiteName;
    /**
     * Constructor method for CollectionInfo
     * @uses CollectionInfo::setAddress()
     * @uses CollectionInfo::setContactNumbers()
     * @uses CollectionInfo::setSiteID()
     * @uses CollectionInfo::setSiteName()
     * @param \Sabre\CreatePassengerNameRecord\Structs\Address $address
     * @param \Sabre\CreatePassengerNameRecord\Structs\ContactNumbers $contactNumbers
     * @param string $siteID
     * @param string $siteName
     */
    public function __construct(\Sabre\CreatePassengerNameRecord\Structs\Address $address = null, \Sabre\CreatePassengerNameRecord\Structs\ContactNumbers $contactNumbers = null, $siteID = null, $siteName = null)
    {
        $this
            ->setAddress($address)
            ->setContactNumbers($contactNumbers)
            ->setSiteID($siteID)
            ->setSiteName($siteName);
    }
    /**
     * Get Address value
     * @return \Sabre\CreatePassengerNameRecord\Structs\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Sabre\CreatePassengerNameRecord\Structs\Address $address
     * @return \Sabre\CreatePassengerNameRecord\Structs\CollectionInfo
     */
    public function setAddress(\Sabre\CreatePassengerNameRecord\Structs\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ContactNumbers value
     * @return \Sabre\CreatePassengerNameRecord\Structs\ContactNumbers|null
     */
    public function getContactNumbers()
    {
        return $this->ContactNumbers;
    }
    /**
     * Set ContactNumbers value
     * @param \Sabre\CreatePassengerNameRecord\Structs\ContactNumbers $contactNumbers
     * @return \Sabre\CreatePassengerNameRecord\Structs\CollectionInfo
     */
    public function setContactNumbers(\Sabre\CreatePassengerNameRecord\Structs\ContactNumbers $contactNumbers = null)
    {
        $this->ContactNumbers = $contactNumbers;
        return $this;
    }
    /**
     * Get SiteID value
     * @return string|null
     */
    public function getSiteID()
    {
        return $this->SiteID;
    }
    /**
     * Set SiteID value
     * @param string $siteID
     * @return \Sabre\CreatePassengerNameRecord\Structs\CollectionInfo
     */
    public function setSiteID($siteID = null)
    {
        $this->SiteID = $siteID;
        return $this;
    }
    /**
     * Get SiteName value
     * @return string|null
     */
    public function getSiteName()
    {
        return $this->SiteName;
    }
    /**
     * Set SiteName value
     * @param string $siteName
     * @return \Sabre\CreatePassengerNameRecord\Structs\CollectionInfo
     */
    public function setSiteName($siteName = null)
    {
        $this->SiteName = $siteName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\CollectionInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
