<?php

namespace Sabre\CreatePassengerNameRecord\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalGuestAmounts Structs
 * @subpackage Structs
 */
class AdditionalGuestAmounts extends AbstractStructBase
{
    /**
     * The NumCribs
     * Meta informations extracted from the WSDL
     * - documentation: "NumCribs" is used to return the number of cribs associated with the particular hotel reservation if applicable.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $NumCribs;
    /**
     * The NumExtraPersons
     * Meta informations extracted from the WSDL
     * - documentation: "NumExtraPersons" is used to return the number of extra persons associated with the particular hotel reservation if applicable.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $NumExtraPersons;
    /**
     * The NumRollaways
     * Meta informations extracted from the WSDL
     * - documentation: "NumRollaways" is used to return the number of rollaways associated with the particular hotel reservation if applicable.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $NumRollaways;
    /**
     * Constructor method for AdditionalGuestAmounts
     * @uses AdditionalGuestAmounts::setNumCribs()
     * @uses AdditionalGuestAmounts::setNumExtraPersons()
     * @uses AdditionalGuestAmounts::setNumRollaways()
     * @param string[] $numCribs
     * @param string[] $numExtraPersons
     * @param string[] $numRollaways
     */
    public function __construct(array $numCribs = array(), array $numExtraPersons = array(), array $numRollaways = array())
    {
        $this
            ->setNumCribs($numCribs)
            ->setNumExtraPersons($numExtraPersons)
            ->setNumRollaways($numRollaways);
    }
    /**
     * Get NumCribs value
     * @return string[]|null
     */
    public function getNumCribs()
    {
        return $this->NumCribs;
    }
    /**
     * Set NumCribs value
     * @throws \InvalidArgumentException
     * @param string[] $numCribs
     * @return \Sabre\CreatePassengerNameRecord\Structs\AdditionalGuestAmounts
     */
    public function setNumCribs(array $numCribs = array())
    {
        $this->NumCribs = $numCribs;
        return $this;
    }
    /**
     * Add item to NumCribs value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\AdditionalGuestAmounts
     */
    public function addToNumCribs($item)
    {
        $this->NumCribs[] = $item;
        return $this;
    }
    /**
     * Get NumExtraPersons value
     * @return string[]|null
     */
    public function getNumExtraPersons()
    {
        return $this->NumExtraPersons;
    }
    /**
     * Set NumExtraPersons value
     * @throws \InvalidArgumentException
     * @param string[] $numExtraPersons
     * @return \Sabre\CreatePassengerNameRecord\Structs\AdditionalGuestAmounts
     */
    public function setNumExtraPersons(array $numExtraPersons = array())
    {
        $this->NumExtraPersons = $numExtraPersons;
        return $this;
    }
    /**
     * Add item to NumExtraPersons value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\AdditionalGuestAmounts
     */
    public function addToNumExtraPersons($item)
    {
        $this->NumExtraPersons[] = $item;
        return $this;
    }
    /**
     * Get NumRollaways value
     * @return string[]|null
     */
    public function getNumRollaways()
    {
        return $this->NumRollaways;
    }
    /**
     * Set NumRollaways value
     * @throws \InvalidArgumentException
     * @param string[] $numRollaways
     * @return \Sabre\CreatePassengerNameRecord\Structs\AdditionalGuestAmounts
     */
    public function setNumRollaways(array $numRollaways = array())
    {
        $this->NumRollaways = $numRollaways;
        return $this;
    }
    /**
     * Add item to NumRollaways value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\CreatePassengerNameRecord\Structs\AdditionalGuestAmounts
     */
    public function addToNumRollaways($item)
    {
        $this->NumRollaways[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\CreatePassengerNameRecord\Structs\AdditionalGuestAmounts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
