<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.sabre.com/wsdl/tpfc/IgnoreTransactionLLS2.0.0RQ.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.sabre.com/wsdl/tpfc/IgnoreTransactionLLS2.0.0RQ.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Sabre\IgnoreTransaction\ClassMap::get(),
);
/**
 * Samples for Ignore ServiceType
 */
$ignore = new \Sabre\IgnoreTransaction\Services\Ignore($options);
$ignore->setSoapHeaderMessageHeader(new \Sabre\IgnoreTransaction\Structs\MessageHeader());
$ignore->setSoapHeaderSecurity(new \Sabre\IgnoreTransaction\Structs\Security());
/**
 * Sample call for IgnoreTransactionRQ operation/method
 */
if ($ignore->IgnoreTransactionRQ(new \Sabre\IgnoreTransaction\Structs\IgnoreTransactionRQ()) !== false) {
    print_r($ignore->getResult());
} else {
    print_r($ignore->getLastError());
}
