<?php

namespace Sabre\IgnoreTransaction\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fault Structs
 * Meta informations extracted from the WSDL
 * - documentation: Fault reporting structure
 * - final: extension
 * - type: tns:Fault
 * @subpackage Structs
 */
class Fault extends AbstractStructBase
{
    /**
     * The faultcode
     * @var string
     */
    public $faultcode;
    /**
     * The faultstring
     * @var string
     */
    public $faultstring;
    /**
     * The faultactor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $faultactor;
    /**
     * The detail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\IgnoreTransaction\Structs\Detail
     */
    public $detail;
    /**
     * Constructor method for Fault
     * @uses Fault::setFaultcode()
     * @uses Fault::setFaultstring()
     * @uses Fault::setFaultactor()
     * @uses Fault::setDetail()
     * @param string $faultcode
     * @param string $faultstring
     * @param string $faultactor
     * @param \Sabre\IgnoreTransaction\Structs\Detail $detail
     */
    public function __construct($faultcode = null, $faultstring = null, $faultactor = null, \Sabre\IgnoreTransaction\Structs\Detail $detail = null)
    {
        $this
            ->setFaultcode($faultcode)
            ->setFaultstring($faultstring)
            ->setFaultactor($faultactor)
            ->setDetail($detail);
    }
    /**
     * Get faultcode value
     * @return string|null
     */
    public function getFaultcode()
    {
        return $this->faultcode;
    }
    /**
     * Set faultcode value
     * @param string $faultcode
     * @return \Sabre\IgnoreTransaction\Structs\Fault
     */
    public function setFaultcode($faultcode = null)
    {
        $this->faultcode = $faultcode;
        return $this;
    }
    /**
     * Get faultstring value
     * @return string|null
     */
    public function getFaultstring()
    {
        return $this->faultstring;
    }
    /**
     * Set faultstring value
     * @param string $faultstring
     * @return \Sabre\IgnoreTransaction\Structs\Fault
     */
    public function setFaultstring($faultstring = null)
    {
        $this->faultstring = $faultstring;
        return $this;
    }
    /**
     * Get faultactor value
     * @return string|null
     */
    public function getFaultactor()
    {
        return $this->faultactor;
    }
    /**
     * Set faultactor value
     * @param string $faultactor
     * @return \Sabre\IgnoreTransaction\Structs\Fault
     */
    public function setFaultactor($faultactor = null)
    {
        $this->faultactor = $faultactor;
        return $this;
    }
    /**
     * Get detail value
     * @return \Sabre\IgnoreTransaction\Structs\Detail|null
     */
    public function getDetail()
    {
        return $this->detail;
    }
    /**
     * Set detail value
     * @param \Sabre\IgnoreTransaction\Structs\Detail $detail
     * @return \Sabre\IgnoreTransaction\Structs\Fault
     */
    public function setDetail(\Sabre\IgnoreTransaction\Structs\Detail $detail = null)
    {
        $this->detail = $detail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\IgnoreTransaction\Structs\Fault
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
