<?php

namespace Sabre\IgnoreTransaction\Enums;

/**
 * This class stands for ErrorType Enums
 * @subpackage Enumerations
 */
class ErrorType
{
    /**
     * Constant for value 'Transport'
     * @return string 'Transport'
     */
    const VALUE_TRANSPORT = 'Transport';
    /**
     * Constant for value 'Validation'
     * @return string 'Validation'
     */
    const VALUE_VALIDATION = 'Validation';
    /**
     * Constant for value 'Application'
     * @return string 'Application'
     */
    const VALUE_APPLICATION = 'Application';
    /**
     * Constant for value 'BusinessLogic'
     * @return string 'BusinessLogic'
     */
    const VALUE_BUSINESS_LOGIC = 'BusinessLogic';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRANSPORT
     * @uses self::VALUE_VALIDATION
     * @uses self::VALUE_APPLICATION
     * @uses self::VALUE_BUSINESS_LOGIC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRANSPORT,
            self::VALUE_VALIDATION,
            self::VALUE_APPLICATION,
            self::VALUE_BUSINESS_LOGIC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
