<?php

namespace Sabre\IgnoreTransaction\Enums;

/**
 * This class stands for DiagnosticLevels Enums
 * @subpackage Enumerations
 */
class DiagnosticLevels
{
    /**
     * Constant for value 'Mock'
     * @return string 'Mock'
     */
    const VALUE_MOCK = 'Mock';
    /**
     * Constant for value 'Simulate'
     * @return string 'Simulate'
     */
    const VALUE_SIMULATE = 'Simulate';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MOCK
     * @uses self::VALUE_SIMULATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MOCK,
            self::VALUE_SIMULATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
