<?php

namespace Sabre\IgnoreTransaction\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProblemBase Structs
 * @subpackage Structs
 */
class ProblemBase extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: An indication of the source of error when processing the request.
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - documentation: Impact of the error on process completion.
     * - use: required
     * @var string
     */
    public $status;
    /**
     * The timeStamp
     * @var string
     */
    public $timeStamp;
    /**
     * Constructor method for ProblemBase
     * @uses ProblemBase::setType()
     * @uses ProblemBase::setStatus()
     * @uses ProblemBase::setTimeStamp()
     * @param string $type
     * @param string $status
     * @param string $timeStamp
     */
    public function __construct($type = null, $status = null, $timeStamp = null)
    {
        $this
            ->setType($type)
            ->setStatus($status)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \Sabre\IgnoreTransaction\Enums\ErrorType::valueIsValid()
     * @uses \Sabre\IgnoreTransaction\Enums\ErrorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Sabre\IgnoreTransaction\Structs\ProblemBase
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \Sabre\IgnoreTransaction\Enums\CompletionCodes::valueIsValid()
     * @uses \Sabre\IgnoreTransaction\Enums\CompletionCodes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \Sabre\IgnoreTransaction\Structs\ProblemBase
     */
    public function setStatus($status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get timeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->timeStamp;
    }
    /**
     * Set timeStamp value
     * @param string $timeStamp
     * @return \Sabre\IgnoreTransaction\Structs\ProblemBase
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->timeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\IgnoreTransaction\Structs\ProblemBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
